/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.netflix.spinnaker.fiat.shared.FiatStatus;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class FiatAuthenticationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FiatAuthenticationFilter.class);
    private final FiatStatus fiatStatus;

    public FiatAuthenticationFilter(FiatStatus fiatStatus) {
        this.fiatStatus = fiatStatus;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.fiatStatus.isEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        Authentication auth = AuthenticatedRequest.getSpinnakerUser().map(username -> new PreAuthenticatedAuthenticationToken(username, null, new ArrayList())).orElseGet(() -> new AnonymousAuthenticationToken("anonymous", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"})));
        SecurityContext ctx = SecurityContextHolder.createEmptyContext();
        ctx.setAuthentication(auth);
        SecurityContextHolder.setContext((SecurityContext)ctx);
        log.debug("Set SecurityContext to user: {}", (Object)auth.getPrincipal().toString());
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

