/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.kork.api.exceptions.AccessDeniedDetails;
import com.netflix.spinnaker.kork.api.exceptions.ExceptionDetails;
import com.netflix.spinnaker.kork.web.exceptions.ExceptionMessageDecorator;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class FiatAccessDeniedExceptionHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DefaultErrorAttributes defaultErrorAttributes = new DefaultErrorAttributes();
    private final ExceptionMessageDecorator exceptionMessageDecorator;

    public FiatAccessDeniedExceptionHandler(ExceptionMessageDecorator exceptionMessageDecorator) {
        this.exceptionMessageDecorator = exceptionMessageDecorator;
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public void handleAccessDeniedException(AccessDeniedException e, HttpServletResponse response, HttpServletRequest request) throws IOException {
        this.storeException(request, response, (Exception)e);
        Map<String, String> headers = this.requestHeaders(request);
        this.log.error("Encountered exception while processing request {}:{} with headers={}", new Object[]{request.getMethod(), request.getRequestURI(), headers.toString(), e});
        String errorMessage = FiatPermissionEvaluator.getAuthorizationFailure().map(authorizationFailure -> this.authorizationFailureMessage((FiatPermissionEvaluator.AuthorizationFailure)authorizationFailure, e)).orElse("Access is denied");
        response.sendError(HttpStatus.FORBIDDEN.value(), errorMessage);
    }

    private String authorizationFailureMessage(FiatPermissionEvaluator.AuthorizationFailure authorizationFailure, AccessDeniedException e) {
        StringJoiner sj = new StringJoiner(" ");
        this.defaultErrorDecoration(sj, authorizationFailure);
        AccessDeniedDetails accessDeniedDetails = new AccessDeniedDetails(authorizationFailure.getResourceType().toString(), authorizationFailure.getResourceName(), authorizationFailure.hasAuthorization() ? authorizationFailure.getAuthorization().toString() : null);
        return this.exceptionMessageDecorator.decorate((Throwable)e, sj.toString(), (ExceptionDetails)accessDeniedDetails);
    }

    private void defaultErrorDecoration(StringJoiner sj, FiatPermissionEvaluator.AuthorizationFailure authorizationFailure) {
        String resourceType = authorizationFailure.getResourceType().toString().replace("_", " ").toLowerCase();
        sj.add("Access denied to").add(resourceType).add(authorizationFailure.getResourceName());
        if (authorizationFailure.hasAuthorization()) {
            sj.add("- required authorization:").add(authorizationFailure.getAuthorization().toString());
        }
    }

    private Map<String, String> requestHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request.getHeaderNames() != null) {
            Enumeration h = request.getHeaderNames();
            while (h.hasMoreElements()) {
                String headerName = (String)h.nextElement();
                String headerValue = request.getHeader(headerName);
                headers.put(headerName, headerValue);
            }
        }
        return headers;
    }

    private void storeException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        this.defaultErrorAttributes.resolveException(request, response, null, ex);
    }
}

