/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="services.fiat")
public class FiatClientConfigurationProperties {
    @Autowired
    private DynamicConfigService dynamicConfigService;
    private boolean enabled;
    private String baseUrl;
    private boolean legacyFallback = false;
    private boolean refreshable = true;
    private Integer connectTimeoutMs;
    private Integer readTimeoutMs;
    @NestedConfigurationProperty
    private PermissionsCache cache = new PermissionsCache();
    @NestedConfigurationProperty
    private RetryConfiguration retry = new RetryConfiguration();
    @NestedConfigurationProperty
    private GrantedAuthorities grantedAuthorities = new GrantedAuthorities();

    public RetryConfiguration getRetry() {
        this.retry.setDynamicConfigService(this.dynamicConfigService);
        return this.retry;
    }

    public DynamicConfigService getDynamicConfigService() {
        return this.dynamicConfigService;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isLegacyFallback() {
        return this.legacyFallback;
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public Integer getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public Integer getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public PermissionsCache getCache() {
        return this.cache;
    }

    public GrantedAuthorities getGrantedAuthorities() {
        return this.grantedAuthorities;
    }

    public FiatClientConfigurationProperties setDynamicConfigService(DynamicConfigService dynamicConfigService) {
        this.dynamicConfigService = dynamicConfigService;
        return this;
    }

    public FiatClientConfigurationProperties setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public FiatClientConfigurationProperties setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public FiatClientConfigurationProperties setLegacyFallback(boolean legacyFallback) {
        this.legacyFallback = legacyFallback;
        return this;
    }

    public FiatClientConfigurationProperties setRefreshable(boolean refreshable) {
        this.refreshable = refreshable;
        return this;
    }

    public FiatClientConfigurationProperties setConnectTimeoutMs(Integer connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
        return this;
    }

    public FiatClientConfigurationProperties setReadTimeoutMs(Integer readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
        return this;
    }

    public FiatClientConfigurationProperties setCache(PermissionsCache cache) {
        this.cache = cache;
        return this;
    }

    public FiatClientConfigurationProperties setRetry(RetryConfiguration retry) {
        this.retry = retry;
        return this;
    }

    public FiatClientConfigurationProperties setGrantedAuthorities(GrantedAuthorities grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiatClientConfigurationProperties)) {
            return false;
        }
        FiatClientConfigurationProperties other = (FiatClientConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isLegacyFallback() != other.isLegacyFallback()) {
            return false;
        }
        if (this.isRefreshable() != other.isRefreshable()) {
            return false;
        }
        Integer this$connectTimeoutMs = this.getConnectTimeoutMs();
        Integer other$connectTimeoutMs = other.getConnectTimeoutMs();
        if (this$connectTimeoutMs == null ? other$connectTimeoutMs != null : !((Object)this$connectTimeoutMs).equals(other$connectTimeoutMs)) {
            return false;
        }
        Integer this$readTimeoutMs = this.getReadTimeoutMs();
        Integer other$readTimeoutMs = other.getReadTimeoutMs();
        if (this$readTimeoutMs == null ? other$readTimeoutMs != null : !((Object)this$readTimeoutMs).equals(other$readTimeoutMs)) {
            return false;
        }
        DynamicConfigService this$dynamicConfigService = this.getDynamicConfigService();
        DynamicConfigService other$dynamicConfigService = other.getDynamicConfigService();
        if (this$dynamicConfigService == null ? other$dynamicConfigService != null : !this$dynamicConfigService.equals(other$dynamicConfigService)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        PermissionsCache this$cache = this.getCache();
        PermissionsCache other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        RetryConfiguration this$retry = this.getRetry();
        RetryConfiguration other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        GrantedAuthorities this$grantedAuthorities = this.getGrantedAuthorities();
        GrantedAuthorities other$grantedAuthorities = other.getGrantedAuthorities();
        return !(this$grantedAuthorities == null ? other$grantedAuthorities != null : !((Object)this$grantedAuthorities).equals(other$grantedAuthorities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FiatClientConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isLegacyFallback() ? 79 : 97);
        result = result * 59 + (this.isRefreshable() ? 79 : 97);
        Integer $connectTimeoutMs = this.getConnectTimeoutMs();
        result = result * 59 + ($connectTimeoutMs == null ? 43 : ((Object)$connectTimeoutMs).hashCode());
        Integer $readTimeoutMs = this.getReadTimeoutMs();
        result = result * 59 + ($readTimeoutMs == null ? 43 : ((Object)$readTimeoutMs).hashCode());
        DynamicConfigService $dynamicConfigService = this.getDynamicConfigService();
        result = result * 59 + ($dynamicConfigService == null ? 43 : $dynamicConfigService.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        PermissionsCache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        RetryConfiguration $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        GrantedAuthorities $grantedAuthorities = this.getGrantedAuthorities();
        result = result * 59 + ($grantedAuthorities == null ? 43 : ((Object)$grantedAuthorities).hashCode());
        return result;
    }

    public String toString() {
        return "FiatClientConfigurationProperties(dynamicConfigService=" + this.getDynamicConfigService() + ", enabled=" + this.isEnabled() + ", baseUrl=" + this.getBaseUrl() + ", legacyFallback=" + this.isLegacyFallback() + ", refreshable=" + this.isRefreshable() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", readTimeoutMs=" + this.getReadTimeoutMs() + ", cache=" + this.getCache() + ", retry=" + this.getRetry() + ", grantedAuthorities=" + this.getGrantedAuthorities() + ")";
    }

    public static class GrantedAuthorities {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public GrantedAuthorities setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GrantedAuthorities)) {
                return false;
            }
            GrantedAuthorities other = (GrantedAuthorities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof GrantedAuthorities;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "FiatClientConfigurationProperties.GrantedAuthorities(enabled=" + this.isEnabled() + ")";
        }
    }

    public static class RetryConfiguration {
        private DynamicConfigService dynamicConfigService;
        private long maxBackoffMillis = 10000L;
        private long initialBackoffMillis = 500L;
        private double retryMultiplier = 1.5;

        public void setDynamicConfigService(DynamicConfigService dynamicConfigService) {
            this.dynamicConfigService = dynamicConfigService;
        }

        public long getMaxBackoffMillis() {
            if (this.dynamicConfigService == null) {
                return this.maxBackoffMillis;
            }
            return (Long)this.dynamicConfigService.getConfig(Long.class, "fiat.retry.maxBackoffMillis", (Object)this.maxBackoffMillis);
        }

        public long getInitialBackoffMillis() {
            if (this.dynamicConfigService == null) {
                return this.initialBackoffMillis;
            }
            return (Long)this.dynamicConfigService.getConfig(Long.class, "fiat.retry.initialBackoffMillis", (Object)this.initialBackoffMillis);
        }

        public double getRetryMultiplier() {
            if (this.dynamicConfigService == null) {
                return this.retryMultiplier;
            }
            return (Double)this.dynamicConfigService.getConfig(Double.class, "fiat.retry.retryMultiplier", (Object)this.retryMultiplier);
        }

        public DynamicConfigService getDynamicConfigService() {
            return this.dynamicConfigService;
        }

        public RetryConfiguration setMaxBackoffMillis(long maxBackoffMillis) {
            this.maxBackoffMillis = maxBackoffMillis;
            return this;
        }

        public RetryConfiguration setInitialBackoffMillis(long initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        public RetryConfiguration setRetryMultiplier(double retryMultiplier) {
            this.retryMultiplier = retryMultiplier;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryConfiguration)) {
                return false;
            }
            RetryConfiguration other = (RetryConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxBackoffMillis() != other.getMaxBackoffMillis()) {
                return false;
            }
            if (this.getInitialBackoffMillis() != other.getInitialBackoffMillis()) {
                return false;
            }
            if (Double.compare(this.getRetryMultiplier(), other.getRetryMultiplier()) != 0) {
                return false;
            }
            DynamicConfigService this$dynamicConfigService = this.getDynamicConfigService();
            DynamicConfigService other$dynamicConfigService = other.getDynamicConfigService();
            return !(this$dynamicConfigService == null ? other$dynamicConfigService != null : !this$dynamicConfigService.equals(other$dynamicConfigService));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RetryConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $maxBackoffMillis = this.getMaxBackoffMillis();
            result = result * 59 + (int)($maxBackoffMillis >>> 32 ^ $maxBackoffMillis);
            long $initialBackoffMillis = this.getInitialBackoffMillis();
            result = result * 59 + (int)($initialBackoffMillis >>> 32 ^ $initialBackoffMillis);
            long $retryMultiplier = Double.doubleToLongBits(this.getRetryMultiplier());
            result = result * 59 + (int)($retryMultiplier >>> 32 ^ $retryMultiplier);
            DynamicConfigService $dynamicConfigService = this.getDynamicConfigService();
            result = result * 59 + ($dynamicConfigService == null ? 43 : $dynamicConfigService.hashCode());
            return result;
        }

        public String toString() {
            return "FiatClientConfigurationProperties.RetryConfiguration(dynamicConfigService=" + this.getDynamicConfigService() + ", maxBackoffMillis=" + this.getMaxBackoffMillis() + ", initialBackoffMillis=" + this.getInitialBackoffMillis() + ", retryMultiplier=" + this.getRetryMultiplier() + ")";
        }
    }

    public static class PermissionsCache {
        private Integer maxEntries = 1000;
        private Integer expiresAfterWriteSeconds = 20;

        public Integer getMaxEntries() {
            return this.maxEntries;
        }

        public Integer getExpiresAfterWriteSeconds() {
            return this.expiresAfterWriteSeconds;
        }

        public PermissionsCache setMaxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public PermissionsCache setExpiresAfterWriteSeconds(Integer expiresAfterWriteSeconds) {
            this.expiresAfterWriteSeconds = expiresAfterWriteSeconds;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionsCache)) {
                return false;
            }
            PermissionsCache other = (PermissionsCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maxEntries = this.getMaxEntries();
            Integer other$maxEntries = other.getMaxEntries();
            if (this$maxEntries == null ? other$maxEntries != null : !((Object)this$maxEntries).equals(other$maxEntries)) {
                return false;
            }
            Integer this$expiresAfterWriteSeconds = this.getExpiresAfterWriteSeconds();
            Integer other$expiresAfterWriteSeconds = other.getExpiresAfterWriteSeconds();
            return !(this$expiresAfterWriteSeconds == null ? other$expiresAfterWriteSeconds != null : !((Object)this$expiresAfterWriteSeconds).equals(other$expiresAfterWriteSeconds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PermissionsCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxEntries = this.getMaxEntries();
            result = result * 59 + ($maxEntries == null ? 43 : ((Object)$maxEntries).hashCode());
            Integer $expiresAfterWriteSeconds = this.getExpiresAfterWriteSeconds();
            result = result * 59 + ($expiresAfterWriteSeconds == null ? 43 : ((Object)$expiresAfterWriteSeconds).hashCode());
            return result;
        }

        public String toString() {
            return "FiatClientConfigurationProperties.PermissionsCache(maxEntries=" + this.getMaxEntries() + ", expiresAfterWriteSeconds=" + this.getExpiresAfterWriteSeconds() + ")";
        }
    }
}

