/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

class HeadersRedactor {
    private static final String WHITELIST_HEADER_PREFIX = "X-";
    private static final String SECRET_DATA_VALUE = "**REDACTED**";

    HeadersRedactor() {
    }

    public Map<String, String> getRedactedHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request.getHeaderNames() != null) {
            Enumeration h = request.getHeaderNames();
            while (h.hasMoreElements()) {
                String headerName = (String)h.nextElement();
                String headerValue = this.getRedactedHeaderValue(headerName, request.getHeader(headerName));
                headers.put(headerName, headerValue);
            }
        }
        return headers;
    }

    private String getRedactedHeaderValue(String headerName, String headerValue) {
        if (!headerName.startsWith(WHITELIST_HEADER_PREFIX)) {
            return SECRET_DATA_VALUE;
        }
        return headerValue;
    }
}

