/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jakewharton.retrofit.Ok3Client;
import com.netflix.spinnaker.config.DefaultServiceEndpoint;
import com.netflix.spinnaker.config.ErrorConfiguration;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.fiat.shared.AuthenticatedRequestAuthenticationConverter;
import com.netflix.spinnaker.fiat.shared.FiatAccessDeniedExceptionHandler;
import com.netflix.spinnaker.fiat.shared.FiatAuthenticationConverter;
import com.netflix.spinnaker.fiat.shared.FiatAuthenticationFilter;
import com.netflix.spinnaker.fiat.shared.FiatClientConfigurationProperties;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.fiat.shared.FiatService;
import com.netflix.spinnaker.fiat.shared.FiatStatus;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerRetrofitErrorHandler;
import com.netflix.spinnaker.kork.web.exceptions.ExceptionMessageDecorator;
import com.netflix.spinnaker.okhttp.SpinnakerRequestInterceptor;
import com.netflix.spinnaker.retrofit.Slf4jRetrofitLogger;
import javax.servlet.Filter;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import retrofit.Endpoints;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@Import(value={ErrorConfiguration.class})
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Configuration
@EnableConfigurationProperties(value={FiatClientConfigurationProperties.class})
@ComponentScan(value={"com.netflix.spinnaker.fiat.shared"})
public class FiatAuthenticationConfig {
    @Autowired(required=false)
    private RestAdapter.LogLevel retrofitLogLevel = RestAdapter.LogLevel.BASIC;

    @Bean
    @ConditionalOnMissingBean(value={FiatService.class})
    public FiatService fiatService(FiatClientConfigurationProperties fiatConfigurationProperties, SpinnakerRequestInterceptor interceptor, OkHttpClientProvider okHttpClientProvider) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OkHttpClient okHttpClient = okHttpClientProvider.getClient((ServiceEndpoint)new DefaultServiceEndpoint("fiat", fiatConfigurationProperties.getBaseUrl()));
        return (FiatService)new RestAdapter.Builder().setEndpoint(Endpoints.newFixedEndpoint((String)fiatConfigurationProperties.getBaseUrl())).setRequestInterceptor((RequestInterceptor)interceptor).setClient((Client)new Ok3Client(okHttpClient)).setConverter((Converter)new JacksonConverter(objectMapper)).setErrorHandler((ErrorHandler)SpinnakerRetrofitErrorHandler.getInstance()).setLogLevel(this.retrofitLogLevel).setLog((RestAdapter.Log)new Slf4jRetrofitLogger(FiatService.class)).build().create(FiatService.class);
    }

    @ConditionalOnProperty(value={"services.fiat.granted-authorities.enabled"})
    @Bean
    AuthenticationConverter fiatAuthenticationFilter(FiatPermissionEvaluator permissionEvaluator) {
        return new FiatAuthenticationConverter(permissionEvaluator);
    }

    @ConditionalOnMissingBean
    @Bean
    AuthenticationConverter defaultAuthenticationConverter() {
        return new AuthenticatedRequestAuthenticationConverter();
    }

    @Bean
    FiatWebSecurityConfigurerAdapter fiatSecurityConfig(FiatStatus fiatStatus, AuthenticationConverter authenticationConverter) {
        return new FiatWebSecurityConfigurerAdapter(fiatStatus, authenticationConverter);
    }

    @Bean
    @Order(value=-2147483648)
    FiatAccessDeniedExceptionHandler fiatAccessDeniedExceptionHandler(ExceptionMessageDecorator exceptionMessageDecorator) {
        return new FiatAccessDeniedExceptionHandler(exceptionMessageDecorator);
    }

    public FiatAuthenticationConfig setRetrofitLogLevel(RestAdapter.LogLevel retrofitLogLevel) {
        this.retrofitLogLevel = retrofitLogLevel;
        return this;
    }

    private static class FiatWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private final FiatStatus fiatStatus;
        private final AuthenticationConverter authenticationConverter;

        private FiatWebSecurityConfigurerAdapter(FiatStatus fiatStatus, AuthenticationConverter authenticationConverter) {
            super(true);
            this.fiatStatus = fiatStatus;
            this.authenticationConverter = authenticationConverter;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.servletApi().and()).exceptionHandling().and()).anonymous().and()).addFilterBefore((Filter)new FiatAuthenticationFilter(this.fiatStatus, this.authenticationConverter), AnonymousAuthenticationFilter.class);
        }
    }
}

