/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.netflix.spinnaker.fiat.model.SpinnakerAuthorities;
import com.netflix.spinnaker.fiat.model.UserPermission;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.kork.common.Header;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class FiatAuthenticationConverter
implements AuthenticationConverter {
    private final FiatPermissionEvaluator permissionEvaluator;

    public Authentication convert(HttpServletRequest request) {
        UserPermission.View permission;
        String user = request.getHeader(Header.USER.getHeader());
        if (user != null && (permission = this.permissionEvaluator.getPermission(user)) != null) {
            return new PreAuthenticatedAuthenticationToken((Object)user, (Object)"N/A", (Collection)permission.toGrantedAuthorities());
        }
        return new AnonymousAuthenticationToken("anonymous", (Object)"anonymous", List.of(SpinnakerAuthorities.ANONYMOUS_AUTHORITY));
    }

    public FiatAuthenticationConverter(FiatPermissionEvaluator permissionEvaluator) {
        this.permissionEvaluator = permissionEvaluator;
    }
}

