/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.netflix.spinnaker.fiat.shared.FiatStatus;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationConverter;

public class FiatAuthenticationFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(FiatAuthenticationFilter.class);
    private final FiatStatus fiatStatus;
    private final AuthenticationConverter authenticationConverter;

    public FiatAuthenticationFilter(FiatStatus fiatStatus, AuthenticationConverter authenticationConverter) {
        this.fiatStatus = fiatStatus;
        this.authenticationConverter = authenticationConverter;
    }

    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.fiatStatus.isEnabled()) {
            SecurityContext ctx = SecurityContextHolder.createEmptyContext();
            Authentication auth = this.authenticationConverter.convert(req);
            ctx.setAuthentication(auth);
            SecurityContextHolder.setContext((SecurityContext)ctx);
            log.debug("Set SecurityContext to user: {}", (Object)auth.getPrincipal().toString());
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }
}

