/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spinnaker.fiat.shared.FiatClientConfigurationProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FiatStatus {
    private final Logger log = LoggerFactory.getLogger(FiatStatus.class);
    private final DynamicConfigService dynamicConfigService;
    private final FiatClientConfigurationProperties fiatClientConfigurationProperties;
    private final AtomicBoolean enabled;
    private final AtomicBoolean legacyFallbackEnabled;
    private final AtomicBoolean grantedAuthoritiesEnabled;

    @Autowired
    public FiatStatus(Registry registry, DynamicConfigService dynamicConfigService, FiatClientConfigurationProperties fiatClientConfigurationProperties) {
        this.dynamicConfigService = dynamicConfigService;
        this.fiatClientConfigurationProperties = fiatClientConfigurationProperties;
        this.enabled = new AtomicBoolean(fiatClientConfigurationProperties.isEnabled());
        this.legacyFallbackEnabled = new AtomicBoolean(fiatClientConfigurationProperties.isLegacyFallback());
        this.grantedAuthoritiesEnabled = new AtomicBoolean(fiatClientConfigurationProperties.getGrantedAuthorities().isEnabled());
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("fiat.enabled")).monitorValue((Object)this.enabled, value -> this.enabled.get() ? 1.0 : 0.0);
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("fiat.legacyFallback.enabled")).monitorValue((Object)this.legacyFallbackEnabled, value -> this.legacyFallbackEnabled.get() ? 1.0 : 0.0);
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("fiat.granted-authorities.enabled")).monitorValue((Object)this.grantedAuthoritiesEnabled, value -> this.grantedAuthoritiesEnabled.get() ? 1.0 : 0.0);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean isLegacyFallbackEnabled() {
        return this.legacyFallbackEnabled.get();
    }

    public boolean isGrantedAuthoritiesEnabled() {
        return this.grantedAuthoritiesEnabled.get();
    }

    @Scheduled(fixedDelay=30000L)
    void refreshStatus() {
        try {
            if (!this.fiatClientConfigurationProperties.isRefreshable()) {
                return;
            }
            this.enabled.set(this.dynamicConfigService.isEnabled("fiat", this.fiatClientConfigurationProperties.isEnabled()));
            this.legacyFallbackEnabled.set(this.dynamicConfigService.isEnabled("fiat.legacyFallback", this.fiatClientConfigurationProperties.isLegacyFallback()));
            this.grantedAuthoritiesEnabled.set(this.dynamicConfigService.isEnabled("fiat.granted-authorities", this.fiatClientConfigurationProperties.getGrantedAuthorities().isEnabled()));
        }
        catch (Exception e) {
            this.log.warn("Unable to refresh fiat status, reason: {}", (Object)e.getMessage());
        }
    }
}

