/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.ErrorConfiguration;
import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.fiat.shared.AuthenticatedRequestAuthenticationConverter;
import com.netflix.spinnaker.fiat.shared.FiatAccessDeniedExceptionHandler;
import com.netflix.spinnaker.fiat.shared.FiatAuthenticationConverter;
import com.netflix.spinnaker.fiat.shared.FiatAuthenticationFilter;
import com.netflix.spinnaker.fiat.shared.FiatClientConfigurationProperties;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.fiat.shared.FiatService;
import com.netflix.spinnaker.fiat.shared.FiatStatus;
import com.netflix.spinnaker.fiat.util.RetrofitUtils;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.web.exceptions.ExceptionMessageDecorator;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Import(value={ErrorConfiguration.class})
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Configuration
@EnableConfigurationProperties(value={FiatClientConfigurationProperties.class})
@ComponentScan(value={"com.netflix.spinnaker.fiat.shared"})
public class FiatAuthenticationConfig {
    @Bean
    @ConditionalOnMissingBean(value={FiatService.class})
    public FiatService fiatService(FiatClientConfigurationProperties fiatConfigurationProperties, OkHttp3ClientConfiguration okHttpClientConfig) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return (FiatService)new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)fiatConfigurationProperties.getBaseUrl())).client(okHttpClientConfig.createForRetrofit2().build()).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).build().create(FiatService.class);
    }

    @ConditionalOnProperty(value={"services.fiat.granted-authorities.enabled"})
    @Bean
    AuthenticationConverter fiatAuthenticationFilter(FiatPermissionEvaluator permissionEvaluator) {
        return new FiatAuthenticationConverter(permissionEvaluator);
    }

    @ConditionalOnMissingBean
    @Bean
    AuthenticationConverter defaultAuthenticationConverter() {
        return new AuthenticatedRequestAuthenticationConverter();
    }

    @Bean
    FiatWebSecurityConfigurerAdapter fiatSecurityConfig(FiatStatus fiatStatus, AuthenticationConverter authenticationConverter) {
        return new FiatWebSecurityConfigurerAdapter(fiatStatus, authenticationConverter);
    }

    @Bean
    @Order(value=-2147483648)
    FiatAccessDeniedExceptionHandler fiatAccessDeniedExceptionHandler(ExceptionMessageDecorator exceptionMessageDecorator) {
        return new FiatAccessDeniedExceptionHandler(exceptionMessageDecorator);
    }

    private static class FiatWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private final FiatStatus fiatStatus;
        private final AuthenticationConverter authenticationConverter;

        private FiatWebSecurityConfigurerAdapter(FiatStatus fiatStatus, AuthenticationConverter authenticationConverter) {
            super(true);
            this.fiatStatus = fiatStatus;
            this.authenticationConverter = authenticationConverter;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.servletApi().and()).exceptionHandling().and()).anonymous().and()).addFilterBefore((Filter)new FiatAuthenticationFilter(this.fiatStatus, this.authenticationConverter), AnonymousAuthenticationFilter.class);
        }
    }
}

