/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.spinnaker.front50.api.model.Timestamped;
import com.netflix.spinnaker.front50.model.GcsStorageServiceException;
import com.netflix.spinnaker.front50.model.ObjectType;
import com.netflix.spinnaker.front50.model.StorageService;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.logstash.logback.argument.StructuredArguments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 B2\u00020\u0001:\u0002BCB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u000f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J0\u0010#\u001a\b\u0012\u0004\u0012\u0002H%0$\"\b\b\u0000\u0010%*\u00020&2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J'\u0010)\u001a\u0002H%\"\b\b\u0000\u0010%*\u00020&2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010*J/\u0010+\u001a\u0002H%\"\b\b\u0000\u0010%*\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J \u00100\u001a\u0006\u0012\u0002\b\u0003012\u0006\u0010\u0014\u001a\u00020\u00102\n\u00102\u001a\u00060\u0011R\u00020\u0000H\u0002J1\u00103\u001a\u00020\u0018\"\n\b\u0000\u0010%*\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u00104\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u000207H\u0016J\u0010\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109J\u001c\u0010:\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00102\n\u0010;\u001a\u00060\u0011R\u00020\u0000H\u0002J \u0010<\u001a\u00060=j\u0002`>2\u0006\u0010?\u001a\u00020\u00052\n\u0010@\u001a\u00060=j\u0002`>H\u0002J\u0010\u0010A\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u00060\u0011R\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/netflix/spinnaker/front50/model/GcsStorageService;", "Lcom/netflix/spinnaker/front50/model/StorageService;", "storage", "Lcom/google/cloud/storage/Storage;", "bucketName", "", "bucketLocation", "basePath", "dataFilename", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/google/cloud/storage/Storage;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/concurrent/ExecutorService;)V", "modTimeState", "", "Lcom/netflix/spinnaker/front50/model/ObjectType;", "Lcom/netflix/spinnaker/front50/model/GcsStorageService$ModificationTimeState;", "blobIdForKey", "Lcom/google/cloud/storage/BlobId;", "objectType", "key", "daoRoot", "deleteObject", "", "objectKey", "ensureBucketExists", "getLastModified", "", "getObjectKey", "blob", "Lcom/google/cloud/storage/Blob;", "rootDirectory", "lastModifiedBlobId", "listObjectKeys", "listObjectVersions", "", "T", "Lcom/netflix/spinnaker/front50/api/model/Timestamped;", "maxResults", "", "loadObject", "(Lcom/netflix/spinnaker/front50/model/ObjectType;Ljava/lang/String;)Lcom/netflix/spinnaker/front50/api/model/Timestamped;", "parseObject", "bytes", "", "([BLcom/netflix/spinnaker/front50/model/ObjectType;Ljava/lang/String;)Lcom/netflix/spinnaker/front50/api/model/Timestamped;", "pathForKey", "scheduleUpdateLastModified", "Ljava/util/concurrent/Future;", "updaterState", "storeObject", "item", "(Lcom/netflix/spinnaker/front50/model/ObjectType;Ljava/lang/String;Lcom/netflix/spinnaker/front50/api/model/Timestamped;)V", "supportsVersioning", "", "bucket", "Lcom/google/cloud/storage/BucketInfo;", "updateLastModified", "state", "wrapException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "e", "writeLastModified", "Companion", "ModificationTimeState", "front50-gcs"})
public final class GcsStorageService
implements StorageService {
    private final Map<ObjectType, ModificationTimeState> modTimeState;
    private final Storage storage;
    private final String bucketName;
    private final String bucketLocation;
    private final String basePath;
    private final String dataFilename;
    private final ObjectMapper objectMapper;
    private final ExecutorService executor;
    private static final Logger log;
    private static final String LAST_MODIFIED_FILENAME = "last-modified";
    private static final Duration WAIT_FOR_TIMESTAMP_UPDATE;
    public static final Companion Companion;

    @PostConstruct
    public final void ensureBucketExists() {
        BucketInfo bucket = (BucketInfo)this.storage.get(this.bucketName, new Storage.BucketGetOption[0]);
        if (bucket == null) {
            BucketInfo.Builder bucketInfo = BucketInfo.newBuilder((String)this.bucketName).setVersioningEnabled(Boolean.valueOf(true));
            CharSequence charSequence = this.bucketLocation;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                bucketInfo.setLocation(this.bucketLocation);
            }
            bucket = bucketInfo.build();
            this.storage.create(bucketInfo.build(), new Storage.BucketTargetOption[0]);
        }
        log.info("Bucket versioning is {}.", (Object)StructuredArguments.value((String)"versioning", (Object)(this.supportsVersioning(bucket) ? "enabled" : "DISABLED")));
    }

    public boolean supportsVersioning() {
        Bucket bucket = this.storage.get(this.bucketName, new Storage.BucketGetOption[]{Storage.BucketGetOption.fields((Storage.BucketField[])new Storage.BucketField[]{Storage.BucketField.VERSIONING})});
        return this.supportsVersioning((BucketInfo)bucket);
    }

    public final boolean supportsVersioning(@Nullable BucketInfo bucket) {
        BucketInfo bucketInfo = bucket;
        return Intrinsics.areEqual((Object)(bucketInfo != null ? bucketInfo.versioningEnabled() : null), (Object)true);
    }

    @NotNull
    public <T extends Timestamped> T loadObject(@NotNull ObjectType objectType, @NotNull String objectKey) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)objectKey, (String)"objectKey");
        try {
            BlobId blobId = this.blobIdForKey(objectType, objectKey);
            Blob blob = this.storage.get(blobId);
            if (blob == null) {
                throw (Throwable)new NotFoundException("Couldn't retrieve " + objectType + ' ' + objectKey + " from GCS");
            }
            Blob blob2 = blob;
            byte[] bytes = this.storage.readAllBytes(blob2.getBlobId(), new Storage.BlobSourceOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            T obj = this.parseObject(bytes, objectType, objectKey);
            obj.setLastModified(blob2.getUpdateTime());
            return obj;
        }
        catch (Exception e) {
            throw (Throwable)this.wrapException("error loading " + objectType + ' ' + objectKey, e);
        }
    }

    public void deleteObject(@NotNull ObjectType objectType, @NotNull String objectKey) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)objectKey, (String)"objectKey");
        try {
            if (this.storage.delete(this.blobIdForKey(objectType, objectKey))) {
                this.writeLastModified(objectType);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.wrapException("error deleting " + objectType + ' ' + objectKey, e);
        }
    }

    public <T extends Timestamped> void storeObject(@NotNull ObjectType objectType, @NotNull String objectKey, T item) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)objectKey, (String)"objectKey");
        BlobId blobId = this.blobIdForKey(objectType, objectKey);
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(item);
            this.storage.create(BlobInfo.newBuilder((BlobId)blobId).setContentType("application/json").build(), bytes, new Storage.BlobTargetOption[0]);
            this.writeLastModified(objectType);
        }
        catch (Exception e) {
            throw (Throwable)this.wrapException("Error writing " + objectType + ' ' + objectKey, e);
        }
    }

    @NotNull
    public Map<String, Long> listObjectKeys(@NotNull ObjectType objectType) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        ImmutableMap.Builder results = ImmutableMap.builder();
        try {
            String rootDirectory = this.daoRoot(objectType);
            Iterable iterable = this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)(rootDirectory + '/'))}).iterateAll();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"storage.list(bucketName,\u2026\"))\n        .iterateAll()");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Blob blob = (Blob)element$iv;
                boolean bl = false;
                Blob blob2 = blob;
                Intrinsics.checkNotNullExpressionValue((Object)blob2, (String)"blob");
                String objectKey = this.getObjectKey(blob2, rootDirectory);
                if (objectKey == null) continue;
                results.put((Object)objectKey, (Object)blob.getUpdateTime());
            }
        }
        catch (Exception e) {
            throw (Throwable)this.wrapException("error listing " + objectType + " objects", e);
        }
        ImmutableMap immutableMap = results.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"results.build()");
        return (Map)immutableMap;
    }

    private final String getObjectKey(Blob blob, String rootDirectory) {
        String string;
        String name;
        String string2 = name = blob.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        if (!StringsKt.startsWith$default((String)string2, (String)(rootDirectory + '/'), (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)name, (String)('/' + this.dataFilename), (boolean)false, (int)2, null)) {
            string = null;
        } else {
            String string3 = name;
            int n = rootDirectory.length() + 1;
            int n2 = name.length() - this.dataFilename.length() - 1;
            boolean bl = false;
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Timestamped> Collection<T> listObjectVersions(@NotNull ObjectType objectType, @NotNull String objectKey, int maxResults) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)objectKey, (String)"objectKey");
        try {
            void $this$mapTo$iv$iv;
            Blob blob;
            void $this$filterTo$iv$iv222;
            String path = this.pathForKey(objectType, objectKey);
            Page listResults = this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path), Storage.BlobListOption.versions((boolean)true)});
            Iterable iterable = listResults.iterateAll();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"listResults.iterateAll()");
            Iterable $this$filter$iv = iterable;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv222) {
                blob = (Blob)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)blob.getName(), (Object)path)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            boolean $this$filterTo$iv$iv222 = false;
            Iterable $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Blob it = (Blob)a;
                    boolean bl2 = false;
                    Blob blob = it;
                    Intrinsics.checkNotNullExpressionValue((Object)blob, (String)"it");
                    it = (Blob)b;
                    Comparable comparable = blob.getUpdateTime();
                    bl2 = false;
                    Blob blob2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)blob2, (String)"it");
                    Long l = blob2.getUpdateTime();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
                }
            })), (int)maxResults);
            boolean $i$f$map = false;
            Iterable $this$filterTo$iv$iv222 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                blob = (Blob)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                byte[] byArray = blob.getContent(new Blob.BlobSourceOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"blob.getContent()");
                T t = this.parseObject(byArray, objectType, objectKey);
                boolean bl2 = false;
                boolean bl3 = false;
                T $this$apply = t;
                boolean bl4 = false;
                $this$apply.setLastModified(blob.getUpdateTime());
                T t2 = t;
                collection.add(t2);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            throw (Throwable)this.wrapException("error loading " + objectType + ' ' + objectKey, e);
        }
    }

    public long getLastModified(@NotNull ObjectType objectType) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        try {
            Blob blob = this.storage.get(this.lastModifiedBlobId(objectType));
            if (blob == null) {
                this.writeLastModified(objectType);
                return 0L;
            }
            Long l = blob.getUpdateTime();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"blob.updateTime");
            return l;
        }
        catch (Exception e) {
            throw (Throwable)this.wrapException("error loading timestamp for " + objectType + " objects", e);
        }
    }

    private final void writeLastModified(ObjectType objectType) {
        ModificationTimeState updaterState = (ModificationTimeState)MapsKt.getValue(this.modTimeState, (Object)objectType);
        Future<?> future = updaterState.updateNeeded();
        try {
            future.get(WAIT_FOR_TIMESTAMP_UPDATE.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateLastModified(ObjectType objectType, ModificationTimeState state) {
        state.updateTaskStarted();
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)this.lastModifiedBlobId(objectType)).build();
        try {
            this.storage.update(blobInfo);
        }
        catch (Exception e) {
            if (e instanceof StorageException && ((StorageException)e).getCode() == 404) {
                try {
                    this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e3) {
                    log.warn("Error updating last modified time for " + objectType, (Throwable)e3);
                }
            } else {
                log.warn("Error updating last modified time for " + objectType, (Throwable)e);
            }
        }
        finally {
            state.updateTaskFinished();
        }
    }

    private final Future<?> scheduleUpdateLastModified(ObjectType objectType, ModificationTimeState updaterState) {
        Future<?> future = this.executor.submit(new Runnable(this, objectType, updaterState){
            final /* synthetic */ GcsStorageService this$0;
            final /* synthetic */ ObjectType $objectType;
            final /* synthetic */ ModificationTimeState $updaterState;

            public final void run() {
                GcsStorageService.access$updateLastModified(this.this$0, this.$objectType, this.$updaterState);
            }
            {
                this.this$0 = gcsStorageService;
                this.$objectType = objectType;
                this.$updaterState = modificationTimeState;
            }
        });
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit { update\u2026jectType, updaterState) }");
        return future;
    }

    private final <T extends Timestamped> T parseObject(byte[] bytes, ObjectType objectType, String objectKey) {
        Timestamped timestamped;
        try {
            Class clazz = objectType.clazz;
            if (clazz == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<T>");
            }
            Object object = this.objectMapper.readValue(bytes, clazz);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.readValue(b\u2026ctType.clazz as Class<T>)");
            timestamped = (Timestamped)object;
        }
        catch (IOException e) {
            throw (Throwable)new GcsStorageServiceException("error reading " + objectType + ' ' + objectKey, e);
        }
        return (T)timestamped;
    }

    private final BlobId blobIdForKey(ObjectType objectType, String key) {
        BlobId blobId = BlobId.of((String)this.bucketName, (String)this.pathForKey(objectType, key));
        Intrinsics.checkNotNullExpressionValue((Object)blobId, (String)"BlobId.of(bucketName, pathForKey(objectType, key))");
        return blobId;
    }

    private final String pathForKey(ObjectType objectType, String key) {
        return this.daoRoot(objectType) + '/' + key + '/' + this.dataFilename;
    }

    private final BlobId lastModifiedBlobId(ObjectType objectType) {
        BlobId blobId = BlobId.of((String)this.bucketName, (String)(this.daoRoot(objectType) + "/last-modified"));
        Intrinsics.checkNotNullExpressionValue((Object)blobId, (String)"BlobId.of(bucketName, \"$\u2026$LAST_MODIFIED_FILENAME\")");
        return blobId;
    }

    private final String daoRoot(ObjectType objectType) {
        return this.basePath + '/' + objectType.group;
    }

    private final Exception wrapException(String message, Exception e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return e;
        }
        if (e instanceof NotFoundException) {
            return e;
        }
        return new GcsStorageServiceException(message, e);
    }

    /*
     * WARNING - void declaration
     */
    public GcsStorageService(@NotNull Storage storage, @NotNull String bucketName, @NotNull String bucketLocation, @NotNull String basePath, @NotNull String dataFilename, @NotNull ObjectMapper objectMapper, @NotNull ExecutorService executor) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
        Intrinsics.checkNotNullParameter((Object)bucketLocation, (String)"bucketLocation");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)dataFilename, (String)"dataFilename");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.storage = storage;
        this.bucketName = bucketName;
        this.bucketLocation = bucketLocation;
        this.basePath = basePath;
        this.dataFilename = dataFilename;
        this.objectMapper = objectMapper;
        this.executor = executor;
        ObjectType[] objectTypeArray = ObjectType.values();
        GcsStorageService gcsStorageService = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var13_14 = $this$mapTo$iv$iv;
        int n = ((void)var13_14).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var17_18 = item$iv$iv = var13_14[i];
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)new ModificationTimeState((ObjectType)it));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        gcsStorageService.modTimeState = MapsKt.toMap((Iterable)collection);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(GcsStorageService.class);
        WAIT_FOR_TIMESTAMP_UPDATE = Duration.ofMillis(500L);
    }

    public static final /* synthetic */ void access$updateLastModified(GcsStorageService $this, ObjectType objectType, ModificationTimeState state) {
        $this.updateLastModified(objectType, state);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/front50/model/GcsStorageService$ModificationTimeState;", "", "objectType", "Lcom/netflix/spinnaker/front50/model/ObjectType;", "(Lcom/netflix/spinnaker/front50/model/GcsStorageService;Lcom/netflix/spinnaker/front50/model/ObjectType;)V", "needsUpdate", "", "updateRunning", "updateNeeded", "Ljava/util/concurrent/Future;", "updateTaskFinished", "", "updateTaskStarted", "front50-gcs"})
    private final class ModificationTimeState {
        private boolean needsUpdate;
        private boolean updateRunning;
        private ObjectType objectType;

        @NotNull
        public final synchronized Future<?> updateNeeded() {
            boolean neededUpdate = this.needsUpdate;
            this.needsUpdate = true;
            if (!neededUpdate && !this.updateRunning) {
                return GcsStorageService.this.scheduleUpdateLastModified(this.objectType, this);
            }
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(null)");
            return (Future)listenableFuture;
        }

        public final synchronized void updateTaskStarted() {
            this.updateRunning = true;
            this.needsUpdate = false;
        }

        public final synchronized void updateTaskFinished() {
            this.updateRunning = false;
            if (this.needsUpdate) {
                GcsStorageService.this.scheduleUpdateLastModified(this.objectType, this);
            }
        }

        public ModificationTimeState(ObjectType objectType) {
            Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
            this.objectType = objectType;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/front50/model/GcsStorageService$Companion;", "", "()V", "LAST_MODIFIED_FILENAME", "", "WAIT_FOR_TIMESTAMP_UPDATE", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "front50-gcs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

