/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.front50.api.model.Timestamped;
import com.netflix.spinnaker.front50.api.model.pipeline.Pipeline;
import com.netflix.spinnaker.front50.config.GcsProperties;
import com.netflix.spinnaker.front50.config.StorageServiceConfigurationProperties;
import com.netflix.spinnaker.front50.jackson.mixins.PipelineMixins;
import com.netflix.spinnaker.front50.jackson.mixins.TimestampedMixins;
import com.netflix.spinnaker.front50.model.DefaultObjectKeyLoader;
import com.netflix.spinnaker.front50.model.GcsStorageService;
import com.netflix.spinnaker.front50.model.ObjectKeyLoader;
import com.netflix.spinnaker.front50.model.StorageService;
import com.netflix.spinnaker.front50.model.application.ApplicationPermissionDAO;
import com.netflix.spinnaker.front50.model.application.DefaultApplicationPermissionDAO;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import rx.schedulers.Schedulers;

@Configuration
@ConditionalOnExpression(value="${spinnaker.gcs.enabled:false}")
@EnableConfigurationProperties(value={GcsProperties.class})
public class GcsConfig {
    private static final Logger log = LoggerFactory.getLogger(GcsConfig.class);
    private static final String DATA_FILENAME = "specification.json";
    private static final String APPLICATION_PERMISSION_DATA_FILENAME = "permission.json";

    @Bean
    public GcsStorageService defaultGoogleCloudStorageService(Storage storage, GcsProperties gcsProperties) {
        return this.googleCloudStorageService(storage, DATA_FILENAME, gcsProperties);
    }

    private GcsStorageService googleCloudStorageService(Storage storage, String dataFilename, GcsProperties gcsProperties) {
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(GcsStorageService.class.getName() + "-%s").build());
        GcsStorageService service = new GcsStorageService(storage, gcsProperties.getBucket(), gcsProperties.getBucketLocation(), gcsProperties.getRootFolder(), dataFilename, new ObjectMapper().addMixIn(Timestamped.class, TimestampedMixins.class).addMixIn(Pipeline.class, PipelineMixins.class), executor);
        log.info("Using Google Cloud Storage bucket={} in project={}", (Object)StructuredArguments.value((String)"bucket", (Object)gcsProperties.getBucket()), (Object)StructuredArguments.value((String)"project", (Object)gcsProperties.getProject()));
        return service;
    }

    @Bean
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    @Qualifier(value="gcsCredentials")
    public Credentials gcsCredentials(GcsProperties gcsProperties) throws IOException {
        GoogleCredentials credentials;
        String jsonPath = gcsProperties.getJsonPath();
        if (!jsonPath.isEmpty()) {
            try (FileInputStream fis = new FileInputStream(jsonPath);){
                credentials = GoogleCredentials.fromStream((InputStream)fis);
            }
            log.info("Loaded GCS credentials from {}", (Object)StructuredArguments.value((String)"jsonPath", (Object)jsonPath));
        } else {
            log.info("spinnaker.gcs.enabled without spinnaker.gcs.jsonPath. Using default application credentials. Using default credentials.");
            credentials = GoogleCredentials.getApplicationDefault();
        }
        return credentials.createScopedRequired() ? credentials.createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control")) : credentials;
    }

    @Bean
    public Storage googleCloudStorage(@Qualifier(value="gcsCredentials") Credentials credentials, GcsProperties properties) {
        return (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials(credentials)).setProjectId(properties.getProject())).build().getService();
    }

    @Bean
    public ApplicationPermissionDAO applicationPermissionDAO(Storage storage, StorageServiceConfigurationProperties storageServiceConfigurationProperties, Registry registry, CircuitBreakerRegistry circuitBreakerRegistry, GcsProperties gcsProperties) {
        GcsStorageService service = this.googleCloudStorageService(storage, APPLICATION_PERMISSION_DATA_FILENAME, gcsProperties);
        DefaultObjectKeyLoader keyLoader = new DefaultObjectKeyLoader((StorageService)service);
        return new DefaultApplicationPermissionDAO((StorageService)service, Schedulers.from((Executor)Executors.newFixedThreadPool(storageServiceConfigurationProperties.getApplicationPermission().getThreadPool())), (ObjectKeyLoader)keyLoader, storageServiceConfigurationProperties.getApplicationPermission().getRefreshMs(), storageServiceConfigurationProperties.getApplicationPermission().getShouldWarmCache(), registry, circuitBreakerRegistry);
    }
}

