/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.spinnaker.front50.api.model.Timestamped;
import com.netflix.spinnaker.front50.model.GcsStorageServiceException;
import com.netflix.spinnaker.front50.model.ObjectType;
import com.netflix.spinnaker.front50.model.StorageService;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.logstash.logback.argument.StructuredArguments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 C2\u00020\u0001:\u0002CDB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u000f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J0\u0010$\u001a\b\u0012\u0004\u0012\u0002H&0%\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0016J'\u0010*\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010+J/\u0010,\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J \u00101\u001a\u0006\u0012\u0002\b\u0003022\u0006\u0010\u0014\u001a\u00020\u00102\n\u00103\u001a\u00060\u0011R\u00020\u0000H\u0002J1\u00104\u001a\u00020\u0018\"\n\b\u0000\u0010&*\u0004\u0018\u00010'2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u00105\u001a\u0002H&H\u0016\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u000208H\u0016J\u0010\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:J\u001c\u0010;\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00102\n\u0010<\u001a\u00060\u0011R\u00020\u0000H\u0002J \u0010=\u001a\u00060>j\u0002`?2\u0006\u0010@\u001a\u00020\u00052\n\u0010A\u001a\u00060>j\u0002`?H\u0002J\u0010\u0010B\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u00060\u0011R\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/netflix/spinnaker/front50/model/GcsStorageService;", "Lcom/netflix/spinnaker/front50/model/StorageService;", "storage", "Lcom/google/cloud/storage/Storage;", "bucketName", "", "bucketLocation", "basePath", "dataFilename", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/google/cloud/storage/Storage;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/concurrent/ExecutorService;)V", "modTimeState", "", "Lcom/netflix/spinnaker/front50/model/ObjectType;", "Lcom/netflix/spinnaker/front50/model/GcsStorageService$ModificationTimeState;", "blobIdForKey", "Lcom/google/cloud/storage/BlobId;", "objectType", "key", "daoRoot", "deleteObject", "", "objectKey", "ensureBucketExists", "getLastModified", "", "getObjectKey", "blob", "Lcom/google/cloud/storage/Blob;", "rootDirectory", "defaultMetadataKey", "lastModifiedBlobId", "listObjectKeys", "listObjectVersions", "", "T", "Lcom/netflix/spinnaker/front50/api/model/Timestamped;", "maxResults", "", "loadObject", "(Lcom/netflix/spinnaker/front50/model/ObjectType;Ljava/lang/String;)Lcom/netflix/spinnaker/front50/api/model/Timestamped;", "parseObject", "bytes", "", "([BLcom/netflix/spinnaker/front50/model/ObjectType;Ljava/lang/String;)Lcom/netflix/spinnaker/front50/api/model/Timestamped;", "pathForKey", "scheduleUpdateLastModified", "Ljava/util/concurrent/Future;", "updaterState", "storeObject", "item", "(Lcom/netflix/spinnaker/front50/model/ObjectType;Ljava/lang/String;Lcom/netflix/spinnaker/front50/api/model/Timestamped;)V", "supportsVersioning", "", "bucket", "Lcom/google/cloud/storage/BucketInfo;", "updateLastModified", "state", "wrapException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "e", "writeLastModified", "Companion", "ModificationTimeState", "front50-gcs"})
public final class GcsStorageService
implements StorageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Storage storage;
    @NotNull
    private final String bucketName;
    @NotNull
    private final String bucketLocation;
    @NotNull
    private final String basePath;
    @NotNull
    private final String dataFilename;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Map<ObjectType, ModificationTimeState> modTimeState;
    private static final Logger log = LoggerFactory.getLogger(GcsStorageService.class);
    @NotNull
    private static final String LAST_MODIFIED_FILENAME = "last-modified";
    private static final Duration WAIT_FOR_TIMESTAMP_UPDATE = Duration.ofMillis(500L);

    /*
     * WARNING - void declaration
     */
    public GcsStorageService(@NotNull Storage storage, @NotNull String bucketName, @NotNull String bucketLocation, @NotNull String basePath, @NotNull String dataFilename, @NotNull ObjectMapper objectMapper, @NotNull ExecutorService executor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
        Intrinsics.checkNotNullParameter((Object)bucketLocation, (String)"bucketLocation");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)dataFilename, (String)"dataFilename");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.storage = storage;
        this.bucketName = bucketName;
        this.bucketLocation = bucketLocation;
        this.basePath = basePath;
        this.dataFilename = dataFilename;
        this.objectMapper = objectMapper;
        this.executor = executor;
        ObjectType[] objectTypeArray = ObjectType.values();
        GcsStorageService gcsStorageService = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var16_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)new ModificationTimeState((ObjectType)it)));
        }
        gcsStorageService.modTimeState = MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @PostConstruct
    public final void ensureBucketExists() {
        BucketInfo bucket = (BucketInfo)this.storage.get(this.bucketName, new Storage.BucketGetOption[0]);
        if (bucket == null) {
            BucketInfo.Builder bucketInfo = BucketInfo.newBuilder((String)this.bucketName).setVersioningEnabled(Boolean.valueOf(true));
            if (!StringsKt.isBlank((CharSequence)this.bucketLocation)) {
                bucketInfo.setLocation(this.bucketLocation);
            }
            bucket = bucketInfo.build();
            this.storage.create(bucketInfo.build(), new Storage.BucketTargetOption[0]);
        }
        log.info("Bucket versioning is {}.", (Object)StructuredArguments.value((String)"versioning", (Object)(this.supportsVersioning(bucket) ? "enabled" : "DISABLED")));
    }

    public boolean supportsVersioning() {
        Storage.BucketGetOption[] bucketGetOptionArray = new Storage.BucketGetOption[1];
        Storage.BucketField[] bucketFieldArray = new Storage.BucketField[]{Storage.BucketField.VERSIONING};
        bucketGetOptionArray[0] = Storage.BucketGetOption.fields((Storage.BucketField[])bucketFieldArray);
        Bucket bucket = this.storage.get(this.bucketName, bucketGetOptionArray);
        return this.supportsVersioning((BucketInfo)bucket);
    }

    public final boolean supportsVersioning(@Nullable BucketInfo bucket) {
        BucketInfo bucketInfo = bucket;
        return bucketInfo != null ? Intrinsics.areEqual((Object)bucketInfo.versioningEnabled(), (Object)true) : false;
    }

    @NotNull
    public <T extends Timestamped> T loadObject(@NotNull ObjectType objectType, @NotNull String objectKey) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)objectKey, (String)"objectKey");
        try {
            BlobId blobId = this.blobIdForKey(objectType, objectKey);
            Blob blob = this.storage.get(blobId);
            if (blob == null) {
                throw new NotFoundException("Couldn't retrieve " + objectType + " " + objectKey + " from GCS");
            }
            Blob blob2 = blob;
            byte[] bytes = this.storage.readAllBytes(blob2.getBlobId(), new Storage.BlobSourceOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            T obj = this.parseObject(bytes, objectType, objectKey);
            obj.setLastModified(blob2.getUpdateTime());
            return obj;
        }
        catch (Exception e) {
            throw this.wrapException("error loading " + objectType + " " + objectKey, e);
        }
    }

    public void deleteObject(@NotNull ObjectType objectType, @NotNull String objectKey) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)objectKey, (String)"objectKey");
        try {
            if (this.storage.delete(this.blobIdForKey(objectType, objectKey))) {
                this.writeLastModified(objectType);
            }
        }
        catch (Exception e) {
            throw this.wrapException("error deleting " + objectType + " " + objectKey, e);
        }
    }

    public <T extends Timestamped> void storeObject(@NotNull ObjectType objectType, @NotNull String objectKey, T item) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)objectKey, (String)"objectKey");
        BlobId blobId = this.blobIdForKey(objectType, objectKey);
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(item);
            this.storage.create(BlobInfo.newBuilder((BlobId)blobId).setContentType("application/json").build(), bytes, new Storage.BlobTargetOption[0]);
            this.writeLastModified(objectType);
        }
        catch (Exception e) {
            throw this.wrapException("Error writing " + objectType + " " + objectKey, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Long> listObjectKeys(@NotNull ObjectType objectType) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        ImmutableMap.Builder results = ImmutableMap.builder();
        try {
            void $this$forEach$iv;
            String rootDirectory = this.daoRoot(objectType);
            Storage.BlobListOption[] blobListOptionArray = new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)(rootDirectory + "/"))};
            Iterable iterable = this.storage.list(this.bucketName, blobListOptionArray).iterateAll();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"storage.list(bucketName,\u2026\"))\n        .iterateAll()");
            Iterable iterable2 = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Blob blob = (Blob)element$iv;
                boolean bl = false;
                String string = blob.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blob.name");
                if (!StringsKt.endsWith$default((String)string, (String)("/" + objectType.getDefaultMetadataFilename(true)), (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)blob, (String)"blob");
                String string2 = objectType.getDefaultMetadataFilename(true);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"objectType.getDefaultMetadataFilename(true)");
                String objectKey = this.getObjectKey(blob, rootDirectory, string2);
                if (objectKey == null) continue;
                results.put((Object)objectKey, (Object)blob.getUpdateTime());
            }
        }
        catch (Exception e) {
            throw this.wrapException("error listing " + objectType + " objects", e);
        }
        ImmutableMap immutableMap = results.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"results.build()");
        return (Map)immutableMap;
    }

    private final String getObjectKey(Blob blob, String rootDirectory, String defaultMetadataKey) {
        String string;
        String name = blob.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        if (!StringsKt.startsWith$default((String)name, (String)(rootDirectory + "/"), (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)name, (String)("/" + defaultMetadataKey), (boolean)false, (int)2, null)) {
            string = null;
        } else {
            String string2 = name.substring(rootDirectory.length() + 1, name.length() - defaultMetadataKey.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Timestamped> Collection<T> listObjectVersions(@NotNull ObjectType objectType, @NotNull String objectKey, int maxResults) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)objectKey, (String)"objectKey");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedBy$iv;
            Blob blob;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String path = this.pathForKey(objectType, objectKey);
            Object object = new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path), Storage.BlobListOption.versions((boolean)true)};
            Page listResults = this.storage.list(this.bucketName, object);
            Iterable iterable = listResults.iterateAll();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"listResults.iterateAll()");
            object = iterable;
            boolean $i$f$filter = false;
            void var8_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                blob = (Blob)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)blob.getName(), (Object)path)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.take((Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Blob it = (Blob)a;
                    boolean bl = false;
                    Comparable comparable = it.getUpdateTime();
                    it = (Blob)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getUpdateTime());
                }
            })), (int)maxResults);
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                T t;
                blob = (Blob)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                byte[] byArray = blob.getContent(new Blob.BlobSourceOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"blob.getContent()");
                T $this$listObjectVersions_u24lambda_u2d5_u24lambda_u2d4 = t = this.parseObject(byArray, objectType, objectKey);
                boolean bl2 = false;
                $this$listObjectVersions_u24lambda_u2d5_u24lambda_u2d4.setLastModified(blob.getUpdateTime());
                collection.add(t);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            throw this.wrapException("error loading " + objectType + " " + objectKey, e);
        }
    }

    public long getLastModified(@NotNull ObjectType objectType) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        try {
            Blob blob = this.storage.get(this.lastModifiedBlobId(objectType));
            if (blob == null) {
                this.writeLastModified(objectType);
                return 0L;
            }
            Long l = blob.getUpdateTime();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"blob.updateTime");
            return ((Number)l).longValue();
        }
        catch (Exception e) {
            throw this.wrapException("error loading timestamp for " + objectType + " objects", e);
        }
    }

    private final void writeLastModified(ObjectType objectType) {
        ModificationTimeState updaterState = (ModificationTimeState)MapsKt.getValue(this.modTimeState, (Object)objectType);
        Future<?> future = updaterState.updateNeeded();
        try {
            future.get(WAIT_FOR_TIMESTAMP_UPDATE.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateLastModified(ObjectType objectType, ModificationTimeState state) {
        state.updateTaskStarted();
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)this.lastModifiedBlobId(objectType)).build();
        try {
            Blob blob = this.storage.get(this.lastModifiedBlobId(objectType));
            if (blob == null) {
                throw new StorageException(404, "no object " + blobInfo + ".bucket/" + blobInfo + ".name");
            }
            Blob lastModified = blob;
            Blob lastUpdated = lastModified.toBuilder().setMetadata(MapsKt.mapOf((Pair)TuplesKt.to((Object)"updateTrigger", (Object)String.valueOf(System.currentTimeMillis())))).build();
            this.storage.update((BlobInfo)lastUpdated);
        }
        catch (Exception e) {
            if (e instanceof StorageException && ((StorageException)e).getCode() == 404) {
                try {
                    this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e3) {
                    log.warn("Error updating last modified time for " + objectType, (Throwable)e3);
                }
            } else {
                log.warn("Error updating last modified time for " + objectType, (Throwable)e);
            }
        }
        finally {
            state.updateTaskFinished();
        }
    }

    private final Future<?> scheduleUpdateLastModified(ObjectType objectType, ModificationTimeState updaterState) {
        Future<?> future = this.executor.submit(() -> GcsStorageService.scheduleUpdateLastModified$lambda-6(this, objectType, updaterState));
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit { update\u2026jectType, updaterState) }");
        return future;
    }

    private final <T extends Timestamped> T parseObject(byte[] bytes, ObjectType objectType, String objectKey) {
        Object object;
        try {
            Class clazz = objectType.clazz;
            if (clazz == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<T of com.netflix.spinnaker.front50.model.GcsStorageService.parseObject>");
            }
            object = this.objectMapper.readValue(bytes, clazz);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n      @Suppress(\"UNCHE\u2026.clazz as Class<T>)\n    }");
            object = (Timestamped)object;
        }
        catch (IOException e) {
            throw new GcsStorageServiceException("error reading " + objectType + " " + objectKey, e);
        }
        return (T)object;
    }

    private final BlobId blobIdForKey(ObjectType objectType, String key) {
        BlobId blobId = BlobId.of((String)this.bucketName, (String)this.pathForKey(objectType, key));
        Intrinsics.checkNotNullExpressionValue((Object)blobId, (String)"of(bucketName, pathForKey(objectType, key))");
        return blobId;
    }

    private final String pathForKey(ObjectType objectType, String key) {
        return this.daoRoot(objectType) + "/" + key + "/" + objectType.getDefaultMetadataFilename(true);
    }

    private final BlobId lastModifiedBlobId(ObjectType objectType) {
        BlobId blobId = BlobId.of((String)this.bucketName, (String)(this.daoRoot(objectType) + "/last-modified"));
        Intrinsics.checkNotNullExpressionValue((Object)blobId, (String)"of(bucketName, \"${daoRoo\u2026$LAST_MODIFIED_FILENAME\")");
        return blobId;
    }

    private final String daoRoot(ObjectType objectType) {
        return this.basePath + "/" + objectType.group;
    }

    private final Exception wrapException(String message, Exception e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return e;
        }
        if (e instanceof NotFoundException) {
            return e;
        }
        return new GcsStorageServiceException(message, e);
    }

    private static final void scheduleUpdateLastModified$lambda-6(GcsStorageService this$0, ObjectType $objectType, ModificationTimeState $updaterState) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$objectType, (String)"$objectType");
        Intrinsics.checkNotNullParameter((Object)$updaterState, (String)"$updaterState");
        this$0.updateLastModified($objectType, $updaterState);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/front50/model/GcsStorageService$Companion;", "", "()V", "LAST_MODIFIED_FILENAME", "", "WAIT_FOR_TIMESTAMP_UPDATE", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "front50-gcs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/front50/model/GcsStorageService$ModificationTimeState;", "", "objectType", "Lcom/netflix/spinnaker/front50/model/ObjectType;", "(Lcom/netflix/spinnaker/front50/model/GcsStorageService;Lcom/netflix/spinnaker/front50/model/ObjectType;)V", "needsUpdate", "", "updateRunning", "updateNeeded", "Ljava/util/concurrent/Future;", "updateTaskFinished", "", "updateTaskStarted", "front50-gcs"})
    private final class ModificationTimeState {
        @NotNull
        private ObjectType objectType;
        private boolean needsUpdate;
        private boolean updateRunning;

        public ModificationTimeState(ObjectType objectType) {
            Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
            this.objectType = objectType;
        }

        @NotNull
        public final synchronized Future<?> updateNeeded() {
            boolean neededUpdate = this.needsUpdate;
            this.needsUpdate = true;
            if (!neededUpdate && !this.updateRunning) {
                return GcsStorageService.this.scheduleUpdateLastModified(this.objectType, this);
            }
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(null)");
            return (Future)listenableFuture;
        }

        public final synchronized void updateTaskStarted() {
            this.updateRunning = true;
            this.needsUpdate = false;
        }

        public final synchronized void updateTaskFinished() {
            this.updateRunning = false;
            if (this.needsUpdate) {
                GcsStorageService.this.scheduleUpdateLastModified(this.objectType, this);
            }
        }
    }
}

