/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.config;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.netflix.spinnaker.front50.config.S3Properties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class S3ClientFactory {
    public static AmazonS3 create(AWSCredentialsProvider awsCredentialsProvider, S3Properties s3Properties) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (s3Properties.getProxyProtocol() != null) {
            if (s3Properties.getProxyProtocol().equalsIgnoreCase("HTTPS")) {
                clientConfiguration.setProtocol(Protocol.HTTPS);
            } else {
                clientConfiguration.setProtocol(Protocol.HTTP);
            }
            Optional.ofNullable(s3Properties.getProxyHost()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyHost(arg_0));
            Optional.ofNullable(s3Properties.getProxyPort()).map(Integer::parseInt).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyPort(arg_0));
        }
        if (!StringUtils.isEmpty((CharSequence)s3Properties.getSignerOverride())) {
            clientConfiguration.setSignerOverride(s3Properties.getSignerOverride());
        }
        AmazonS3Client client = new AmazonS3Client(awsCredentialsProvider, clientConfiguration);
        S3ClientOptions.Builder clientOptionsBuilder = S3ClientOptions.builder();
        if (s3Properties.getPayloadSigning() != null) {
            clientOptionsBuilder.setPayloadSigningEnabled(s3Properties.getPayloadSigning().booleanValue());
        }
        if (!StringUtils.isEmpty((CharSequence)s3Properties.getEndpoint())) {
            client.setEndpoint(s3Properties.getEndpoint());
            if (!StringUtils.isEmpty((CharSequence)s3Properties.getRegionOverride())) {
                client.setSignerRegionOverride(s3Properties.getRegionOverride());
            }
            clientOptionsBuilder.setPathStyleAccess(s3Properties.getPathStyleAccess().booleanValue());
        } else {
            Optional.ofNullable(s3Properties.getRegion()).map(Regions::fromName).map(Region::getRegion).ifPresent(arg_0 -> ((AmazonS3Client)client).setRegion(arg_0));
        }
        client.setS3ClientOptions(clientOptionsBuilder.build());
        return client;
    }
}

