/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.config;

import com.netflix.spinnaker.front50.config.S3BucketProperties;
import com.netflix.spinnaker.front50.config.S3EventingProperties;
import com.netflix.spinnaker.front50.config.S3FailoverProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public abstract class S3Properties
extends S3BucketProperties {
    String rootFolder = "front50";
    @NestedConfigurationProperty
    S3FailoverProperties failover = new S3FailoverProperties();
    @NestedConfigurationProperty
    S3EventingProperties eventing = new S3EventingProperties();
    private Integer maxKeys = 10000;

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    public S3FailoverProperties getFailover() {
        return this.failover;
    }

    public void setFailover(S3FailoverProperties failover) {
        this.failover = failover;
    }

    public boolean isFailoverEnabled() {
        return this.failover != null && this.failover.enabled;
    }

    public S3EventingProperties getEventing() {
        return this.eventing;
    }

    public void setEventing(S3EventingProperties eventing) {
        this.eventing = eventing;
    }

    @Override
    public String getBucket() {
        if (this.isFailoverEnabled()) {
            return this.failover.getBucket();
        }
        return super.getBucket();
    }

    @Override
    public String getRegion() {
        if (this.isFailoverEnabled()) {
            return this.failover.getRegion();
        }
        return super.getRegion();
    }

    @Override
    public String getRegionOverride() {
        if (this.isFailoverEnabled()) {
            return this.failover.getRegionOverride();
        }
        return super.getRegionOverride();
    }

    @Override
    public String getEndpoint() {
        if (this.isFailoverEnabled()) {
            return this.failover.getEndpoint();
        }
        return super.getEndpoint();
    }

    @Override
    public String getProxyHost() {
        if (this.isFailoverEnabled()) {
            return this.failover.getProxyHost();
        }
        return super.getProxyHost();
    }

    @Override
    public String getProxyPort() {
        if (this.isFailoverEnabled()) {
            return this.failover.getProxyPort();
        }
        return super.getProxyPort();
    }

    @Override
    public String getProxyProtocol() {
        if (this.isFailoverEnabled()) {
            return this.failover.getProxyProtocol();
        }
        return super.getProxyProtocol();
    }

    @Override
    public Boolean getVersioning() {
        if (this.isFailoverEnabled()) {
            return this.failover.getVersioning();
        }
        return super.getVersioning();
    }
}

