/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.plugins;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.netflix.spinnaker.front50.config.S3PluginStorageProperties;
import com.netflix.spinnaker.front50.plugins.PluginBinaryAlreadyExistsException;
import com.netflix.spinnaker.front50.plugins.PluginBinaryStorageService;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class S3PluginBinaryStorageService
implements PluginBinaryStorageService {
    private final AmazonS3 amazonS3;
    private final S3PluginStorageProperties properties;

    public S3PluginBinaryStorageService(AmazonS3 amazonS3, S3PluginStorageProperties properties) {
        this.amazonS3 = amazonS3;
        this.properties = properties;
    }

    public void store(@Nonnull String key, @Nonnull byte[] item) {
        if (this.amazonS3.doesObjectExist(this.properties.getBucket(), this.buildObjectKey(key))) {
            throw new PluginBinaryAlreadyExistsException(key);
        }
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)item.length);
        metadata.setContentMD5(Base64.getEncoder().encodeToString(Hashing.md5().hashBytes(item).asBytes()));
        this.amazonS3.putObject(this.properties.getBucket(), this.buildObjectKey(key), (InputStream)new ByteArrayInputStream(item), metadata);
    }

    public void delete(@Nonnull String key) {
        this.amazonS3.deleteObject(this.properties.getBucket(), this.buildObjectKey(key));
    }

    @Nonnull
    public List<String> listKeys() {
        ObjectListing listing = this.amazonS3.listObjects(new ListObjectsRequest(this.properties.getBucket(), this.buildFolder(), null, null, Integer.valueOf(1000)));
        List summaries = listing.getObjectSummaries();
        while (listing.isTruncated()) {
            listing = this.amazonS3.listNextBatchOfObjects(listing);
            summaries.addAll(listing.getObjectSummaries());
        }
        return summaries.stream().map(S3ObjectSummary::getKey).filter(k -> k.endsWith(".zip")).collect(Collectors.toList());
    }

    @Nullable
    public byte[] load(@Nonnull String key) {
        S3Object object;
        try {
            object = this.amazonS3.getObject(this.properties.getBucket(), this.buildObjectKey(key));
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
        try {
            return ByteStreams.toByteArray((InputStream)object.getObjectContent());
        }
        catch (IOException e) {
            throw new SystemException(String.format("Failed to read object contents: %s", key), (Throwable)e);
        }
    }

    private String buildFolder() {
        return (this.properties.getRootFolder() + "/plugins").replaceAll("//", "/");
    }

    private String buildObjectKey(String key) {
        return (this.buildFolder() + "/" + key).replaceAll("//", "/");
    }
}

