/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.model;

import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.actions.SQSActions;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.Topic;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiptHandleIsInvalidException;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PreDestroy;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporarySQSQueue {
    private final Logger log = LoggerFactory.getLogger(TemporarySQSQueue.class);
    private final AmazonSQS amazonSQS;
    private final AmazonSNS amazonSNS;
    private final TemporaryQueue temporaryQueue;

    public TemporarySQSQueue(AmazonSQS amazonSQS, AmazonSNS amazonSNS, String snsTopicName, String instanceId) {
        this.amazonSQS = amazonSQS;
        this.amazonSNS = amazonSNS;
        String sanitizedInstanceId = TemporarySQSQueue.getSanitizedInstanceId(instanceId);
        String snsTopicArn = this.getSnsTopicArn(amazonSNS, snsTopicName);
        String sqsQueueName = snsTopicName + "__" + sanitizedInstanceId;
        String sqsQueueArn = snsTopicArn.substring(0, snsTopicArn.lastIndexOf(":") + 1).replace("sns", "sqs") + sqsQueueName;
        this.temporaryQueue = this.createQueue(snsTopicArn, sqsQueueArn, sqsQueueName);
    }

    List<Message> fetchMessages() {
        ReceiveMessageResult receiveMessageResult = this.amazonSQS.receiveMessage(new ReceiveMessageRequest(this.temporaryQueue.sqsQueueUrl).withMaxNumberOfMessages(Integer.valueOf(10)).withWaitTimeSeconds(Integer.valueOf(1)));
        return receiveMessageResult.getMessages();
    }

    void markMessageAsHandled(String receiptHandle) {
        try {
            this.amazonSQS.deleteMessage(this.temporaryQueue.sqsQueueUrl, receiptHandle);
        }
        catch (ReceiptHandleIsInvalidException e) {
            this.log.warn("Error deleting message, reason: {} (receiptHandle: {})", (Object)e.getMessage(), (Object)StructuredArguments.value((String)"receiptHandle", (Object)receiptHandle));
        }
    }

    @PreDestroy
    void shutdown() {
        try {
            this.log.debug("Removing Temporary S3 Notification Queue: {}", (Object)StructuredArguments.value((String)"queue", (Object)this.temporaryQueue.sqsQueueUrl));
            this.amazonSQS.deleteQueue(this.temporaryQueue.sqsQueueUrl);
            this.log.debug("Removed Temporary S3 Notification Queue: {}", (Object)StructuredArguments.value((String)"queue", (Object)this.temporaryQueue.sqsQueueUrl));
        }
        catch (Exception e) {
            this.log.error("Unable to remove queue: {} (reason: {})", new Object[]{StructuredArguments.value((String)"queue", (Object)this.temporaryQueue.sqsQueueUrl), e.getMessage(), e});
        }
        try {
            this.log.debug("Removing S3 Notification Subscription: {}", (Object)this.temporaryQueue.snsTopicSubscriptionArn);
            this.amazonSNS.unsubscribe(this.temporaryQueue.snsTopicSubscriptionArn);
            this.log.debug("Removed S3 Notification Subscription: {}", (Object)this.temporaryQueue.snsTopicSubscriptionArn);
        }
        catch (Exception e) {
            this.log.error("Unable to unsubscribe queue from topic: {} (reason: {})", new Object[]{StructuredArguments.value((String)"topic", (Object)this.temporaryQueue.snsTopicSubscriptionArn), e.getMessage(), e});
        }
    }

    private String getSnsTopicArn(AmazonSNS amazonSNS, String topicName) {
        ListTopicsResult listTopicsResult = amazonSNS.listTopics();
        String nextToken = listTopicsResult.getNextToken();
        List topics = listTopicsResult.getTopics();
        while (nextToken != null) {
            listTopicsResult = amazonSNS.listTopics(nextToken);
            nextToken = listTopicsResult.getNextToken();
            topics.addAll(listTopicsResult.getTopics());
        }
        return topics.stream().filter(t -> t.getTopicArn().toLowerCase().endsWith(":" + topicName.toLowerCase())).map(Topic::getTopicArn).findFirst().orElseThrow(() -> new IllegalArgumentException("No SNS topic found (topicName: " + topicName + ")"));
    }

    private TemporaryQueue createQueue(String snsTopicArn, String sqsQueueArn, String sqsQueueName) {
        String sqsQueueUrl = this.amazonSQS.createQueue(new CreateQueueRequest().withQueueName(sqsQueueName).withAttributes(Collections.singletonMap("MessageRetentionPeriod", "60"))).getQueueUrl();
        this.log.info("Created Temporary S3 Notification Queue: {}", (Object)StructuredArguments.value((String)"queue", (Object)sqsQueueUrl));
        String snsTopicSubscriptionArn = this.amazonSNS.subscribe(snsTopicArn, "sqs", sqsQueueArn).getSubscriptionArn();
        Statement snsStatement = new Statement(Statement.Effect.Allow).withActions(new Action[]{SQSActions.SendMessage});
        snsStatement.setPrincipals(new Principal[]{Principal.All});
        snsStatement.setResources(Collections.singletonList(new Resource(sqsQueueArn)));
        snsStatement.setConditions(Collections.singletonList(new Condition().withType("ArnEquals").withConditionKey("aws:SourceArn").withValues(new String[]{snsTopicArn})));
        Policy allowSnsPolicy = new Policy("allow-sns", Collections.singletonList(snsStatement));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("Policy", allowSnsPolicy.toJson());
        this.amazonSQS.setQueueAttributes(sqsQueueUrl, attributes);
        return new TemporaryQueue(snsTopicArn, sqsQueueArn, sqsQueueUrl, snsTopicSubscriptionArn);
    }

    static String getSanitizedInstanceId(String instanceId) {
        return instanceId.replaceAll("[^\\w\\-]", "_");
    }

    protected static class TemporaryQueue {
        final String snsTopicArn;
        final String sqsQueueArn;
        final String sqsQueueUrl;
        final String snsTopicSubscriptionArn;

        TemporaryQueue(String snsTopicArn, String sqsQueueArn, String sqsQueueUrl, String snsTopicSubscriptionArn) {
            this.snsTopicArn = snsTopicArn;
            this.sqsQueueArn = sqsQueueArn;
            this.sqsQueueUrl = sqsQueueUrl;
            this.snsTopicSubscriptionArn = snsTopicSubscriptionArn;
        }
    }
}

