/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.config;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.front50.api.model.Timestamped;
import com.netflix.spinnaker.front50.api.model.pipeline.Pipeline;
import com.netflix.spinnaker.front50.config.S3ClientFactory;
import com.netflix.spinnaker.front50.config.S3MetadataStorageProperties;
import com.netflix.spinnaker.front50.config.S3PluginStorageProperties;
import com.netflix.spinnaker.front50.jackson.mixins.PipelineMixins;
import com.netflix.spinnaker.front50.jackson.mixins.TimestampedMixins;
import com.netflix.spinnaker.front50.model.EventingS3ObjectKeyLoader;
import com.netflix.spinnaker.front50.model.ObjectKeyLoader;
import com.netflix.spinnaker.front50.model.S3StorageService;
import com.netflix.spinnaker.front50.model.StorageService;
import com.netflix.spinnaker.front50.model.TemporarySQSQueue;
import com.netflix.spinnaker.front50.plugins.PluginBinaryStorageService;
import com.netflix.spinnaker.front50.plugins.S3PluginBinaryStorageService;
import com.netflix.spinnaker.kork.aws.bastion.BastionConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.concurrent.Executors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(value={"spinnaker.s3.enabled"})
@Import(value={BastionConfig.class})
@EnableConfigurationProperties(value={S3MetadataStorageProperties.class, S3PluginStorageProperties.class})
public class S3Config {
    @Bean
    @ConditionalOnProperty(value={"spinnaker.s3.storage-service.enabled"}, matchIfMissing=true)
    public AmazonS3 awsS3MetadataClient(AWSCredentialsProvider awsCredentialsProvider, S3MetadataStorageProperties s3Properties) {
        return S3ClientFactory.create(awsCredentialsProvider, s3Properties);
    }

    @Bean
    @ConditionalOnProperty(value={"spinnaker.s3.storage-service.enabled"}, matchIfMissing=true)
    public S3StorageService s3StorageService(AmazonS3 awsS3MetadataClient, S3MetadataStorageProperties s3Properties) {
        ObjectMapper awsObjectMapper = new ObjectMapper().addMixIn(Timestamped.class, TimestampedMixins.class).addMixIn(Pipeline.class, PipelineMixins.class);
        S3StorageService service = new S3StorageService(awsObjectMapper, awsS3MetadataClient, s3Properties.getBucket(), s3Properties.getRootFolder(), s3Properties.isFailoverEnabled(), s3Properties.getRegion(), s3Properties.getVersioning(), s3Properties.getMaxKeys(), s3Properties.getServerSideEncryption());
        service.ensureBucketExists();
        return service;
    }

    @Bean
    @ConditionalOnProperty(value={"spinnaker.s3.plugin-storage.enabled"})
    public AmazonS3 awsS3PluginClient(AWSCredentialsProvider awsCredentialsProvider, S3PluginStorageProperties s3Properties) {
        return S3ClientFactory.create(awsCredentialsProvider, s3Properties);
    }

    @Bean
    @ConditionalOnProperty(value={"spinnaker.s3.plugin-storage.enabled"})
    PluginBinaryStorageService pluginBinaryStorageService(AmazonS3 awsS3PluginClient, S3PluginStorageProperties properties) {
        return new S3PluginBinaryStorageService(awsS3PluginClient, properties);
    }

    @Bean
    @ConditionalOnProperty(value={"spinnaker.s3.eventing.enabled"})
    public AmazonSQS awsSQSClient(AWSCredentialsProvider awsCredentialsProvider, S3MetadataStorageProperties s3Properties) {
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(new ClientConfiguration())).withRegion(s3Properties.getRegion())).build();
    }

    @Bean
    @ConditionalOnProperty(value={"spinnaker.s3.eventing.enabled"})
    public AmazonSNS awsSNSClient(AWSCredentialsProvider awsCredentialsProvider, S3MetadataStorageProperties s3Properties) {
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(new ClientConfiguration())).withRegion(s3Properties.getRegion())).build();
    }

    @Bean
    @ConditionalOnProperty(value={"spinnaker.s3.eventing.enabled"})
    public TemporarySQSQueue temporaryQueueSupport(Optional<ApplicationInfoManager> applicationInfoManager, AmazonSQS amazonSQS, AmazonSNS amazonSNS, S3MetadataStorageProperties s3Properties) {
        return new TemporarySQSQueue(amazonSQS, amazonSNS, s3Properties.getEventing().getSnsTopicName(), S3Config.getInstanceId(applicationInfoManager));
    }

    @Bean
    @ConditionalOnProperty(value={"spinnaker.s3.eventing.enabled"})
    public ObjectKeyLoader eventingS3ObjectKeyLoader(ObjectMapper objectMapper, S3MetadataStorageProperties s3Properties, StorageService storageService, TemporarySQSQueue temporaryQueueSupport, Registry registry) {
        return new EventingS3ObjectKeyLoader(Executors.newFixedThreadPool(1), objectMapper, s3Properties, temporaryQueueSupport, storageService, registry, true);
    }

    private static String getInstanceId(Optional<ApplicationInfoManager> applicationInfoManager) {
        if (applicationInfoManager.isPresent()) {
            return applicationInfoManager.get().getInfo().getInstanceId();
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }
}

