/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.aws.security;

import com.amazonaws.services.s3.AmazonS3;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.kayenta.aws.security.AwsCredentials;
import com.netflix.kayenta.security.AccountCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;

public class AwsNamedAccountCredentials
implements AccountCredentials<AwsCredentials> {
    @NotNull
    private String name;
    @NotNull
    private List<AccountCredentials.Type> supportedTypes;
    @NotNull
    private AwsCredentials credentials;
    private String bucket;
    private String region;
    private String rootFolder;
    @JsonIgnore
    private AmazonS3 amazonS3;

    public String getType() {
        return "aws";
    }

    AwsNamedAccountCredentials(String name, List<AccountCredentials.Type> supportedTypes, AwsCredentials credentials, String bucket, String region, String rootFolder, AmazonS3 amazonS3) {
        this.name = name;
        this.supportedTypes = supportedTypes;
        this.credentials = credentials;
        this.bucket = bucket;
        this.region = region;
        this.rootFolder = rootFolder;
        this.amazonS3 = amazonS3;
    }

    public static AwsNamedAccountCredentialsBuilder builder() {
        return new AwsNamedAccountCredentialsBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<AccountCredentials.Type> getSupportedTypes() {
        return this.supportedTypes;
    }

    public AwsCredentials getCredentials() {
        return this.credentials;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public AmazonS3 getAmazonS3() {
        return this.amazonS3;
    }

    public AwsNamedAccountCredentials setName(String name) {
        this.name = name;
        return this;
    }

    public AwsNamedAccountCredentials setSupportedTypes(List<AccountCredentials.Type> supportedTypes) {
        this.supportedTypes = supportedTypes;
        return this;
    }

    public AwsNamedAccountCredentials setCredentials(AwsCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public AwsNamedAccountCredentials setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public AwsNamedAccountCredentials setRegion(String region) {
        this.region = region;
        return this;
    }

    public AwsNamedAccountCredentials setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
        return this;
    }

    public AwsNamedAccountCredentials setAmazonS3(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsNamedAccountCredentials)) {
            return false;
        }
        AwsNamedAccountCredentials other = (AwsNamedAccountCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<AccountCredentials.Type> this$supportedTypes = this.getSupportedTypes();
        List<AccountCredentials.Type> other$supportedTypes = other.getSupportedTypes();
        if (this$supportedTypes == null ? other$supportedTypes != null : !((Object)this$supportedTypes).equals(other$supportedTypes)) {
            return false;
        }
        AwsCredentials this$credentials = this.getCredentials();
        AwsCredentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$rootFolder = this.getRootFolder();
        String other$rootFolder = other.getRootFolder();
        if (this$rootFolder == null ? other$rootFolder != null : !this$rootFolder.equals(other$rootFolder)) {
            return false;
        }
        AmazonS3 this$amazonS3 = this.getAmazonS3();
        AmazonS3 other$amazonS3 = other.getAmazonS3();
        return !(this$amazonS3 == null ? other$amazonS3 != null : !this$amazonS3.equals(other$amazonS3));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AwsNamedAccountCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<AccountCredentials.Type> $supportedTypes = this.getSupportedTypes();
        result = result * 59 + ($supportedTypes == null ? 43 : ((Object)$supportedTypes).hashCode());
        AwsCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $rootFolder = this.getRootFolder();
        result = result * 59 + ($rootFolder == null ? 43 : $rootFolder.hashCode());
        AmazonS3 $amazonS3 = this.getAmazonS3();
        result = result * 59 + ($amazonS3 == null ? 43 : $amazonS3.hashCode());
        return result;
    }

    public String toString() {
        return "AwsNamedAccountCredentials(name=" + this.getName() + ", supportedTypes=" + this.getSupportedTypes() + ", credentials=" + this.getCredentials() + ", bucket=" + this.getBucket() + ", region=" + this.getRegion() + ", rootFolder=" + this.getRootFolder() + ", amazonS3=" + this.getAmazonS3() + ")";
    }

    public static class AwsNamedAccountCredentialsBuilder {
        private String name;
        private ArrayList<AccountCredentials.Type> supportedTypes;
        private AwsCredentials credentials;
        private String bucket;
        private String region;
        private String rootFolder;
        private AmazonS3 amazonS3;

        AwsNamedAccountCredentialsBuilder() {
        }

        public AwsNamedAccountCredentialsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AwsNamedAccountCredentialsBuilder supportedType(AccountCredentials.Type supportedType) {
            if (this.supportedTypes == null) {
                this.supportedTypes = new ArrayList();
            }
            this.supportedTypes.add(supportedType);
            return this;
        }

        public AwsNamedAccountCredentialsBuilder supportedTypes(Collection<? extends AccountCredentials.Type> supportedTypes) {
            if (supportedTypes == null) {
                throw new IllegalArgumentException("supportedTypes cannot be null");
            }
            if (this.supportedTypes == null) {
                this.supportedTypes = new ArrayList();
            }
            this.supportedTypes.addAll(supportedTypes);
            return this;
        }

        public AwsNamedAccountCredentialsBuilder clearSupportedTypes() {
            if (this.supportedTypes != null) {
                this.supportedTypes.clear();
            }
            return this;
        }

        public AwsNamedAccountCredentialsBuilder credentials(AwsCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public AwsNamedAccountCredentialsBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public AwsNamedAccountCredentialsBuilder region(String region) {
            this.region = region;
            return this;
        }

        public AwsNamedAccountCredentialsBuilder rootFolder(String rootFolder) {
            this.rootFolder = rootFolder;
            return this;
        }

        public AwsNamedAccountCredentialsBuilder amazonS3(AmazonS3 amazonS3) {
            this.amazonS3 = amazonS3;
            return this;
        }

        public AwsNamedAccountCredentials build() {
            List<AccountCredentials.Type> supportedTypes;
            switch (this.supportedTypes == null ? 0 : this.supportedTypes.size()) {
                case 0: {
                    supportedTypes = Collections.emptyList();
                    break;
                }
                case 1: {
                    supportedTypes = Collections.singletonList(this.supportedTypes.get(0));
                    break;
                }
                default: {
                    supportedTypes = Collections.unmodifiableList(new ArrayList<AccountCredentials.Type>(this.supportedTypes));
                }
            }
            return new AwsNamedAccountCredentials(this.name, supportedTypes, this.credentials, this.bucket, this.region, this.rootFolder, this.amazonS3);
        }

        public String toString() {
            return "AwsNamedAccountCredentials.AwsNamedAccountCredentialsBuilder(name=" + this.name + ", supportedTypes=" + this.supportedTypes + ", credentials=" + this.credentials + ", bucket=" + this.bucket + ", region=" + this.region + ", rootFolder=" + this.rootFolder + ", amazonS3=" + this.amazonS3 + ")";
        }
    }
}

