/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.aws.config;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.netflix.kayenta.aws.config.AwsConfigurationProperties;
import com.netflix.kayenta.aws.config.AwsManagedAccount;
import com.netflix.kayenta.aws.security.AwsCredentials;
import com.netflix.kayenta.aws.security.AwsNamedAccountCredentials;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"kayenta.aws.enabled"})
@ComponentScan(value={"com.netflix.kayenta.aws"})
public class AwsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AwsConfiguration.class);

    @Bean
    @ConfigurationProperties(value="kayenta.aws")
    AwsConfigurationProperties awsConfigurationProperties() {
        return new AwsConfigurationProperties();
    }

    @Bean
    boolean registerAwsCredentials(AwsConfigurationProperties awsConfigurationProperties, AccountCredentialsRepository accountCredentialsRepository) throws IOException {
        for (AwsManagedAccount awsManagedAccount : awsConfigurationProperties.getAccounts()) {
            String endpoint;
            AwsManagedAccount.ExplicitAwsCredentials explicitCredentials;
            String name = awsManagedAccount.getName();
            List<AccountCredentials.Type> supportedTypes = awsManagedAccount.getSupportedTypes();
            log.info("Registering AWS account {} with supported types {}.", (Object)name, supportedTypes);
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            if (awsManagedAccount.getProxyProtocol() != null) {
                if (awsManagedAccount.getProxyProtocol().equalsIgnoreCase("HTTPS")) {
                    clientConfiguration.setProtocol(Protocol.HTTPS);
                } else {
                    clientConfiguration.setProtocol(Protocol.HTTP);
                }
                Optional.ofNullable(awsManagedAccount.getProxyHost()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyHost(arg_0));
                Optional.ofNullable(awsManagedAccount.getProxyPort()).map(Integer::parseInt).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyPort(arg_0));
            }
            AmazonS3ClientBuilder amazonS3ClientBuilder = AmazonS3ClientBuilder.standard();
            String profileName = awsManagedAccount.getProfileName();
            if (!StringUtils.isEmpty((Object)profileName)) {
                amazonS3ClientBuilder.withCredentials((AWSCredentialsProvider)new ProfileCredentialsProvider(profileName));
            }
            if ((explicitCredentials = awsManagedAccount.getExplicitCredentials()) != null) {
                String sessionToken = explicitCredentials.getSessionToken();
                BasicAWSCredentials awsCreds = sessionToken == null ? new BasicAWSCredentials(explicitCredentials.getAccessKey(), explicitCredentials.getSecretKey()) : new BasicSessionCredentials(explicitCredentials.getAccessKey(), explicitCredentials.getSecretKey(), sessionToken);
                amazonS3ClientBuilder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds));
            }
            if (!StringUtils.isEmpty((Object)(endpoint = awsManagedAccount.getEndpoint()))) {
                amazonS3ClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, null));
                amazonS3ClientBuilder.setPathStyleAccessEnabled(Boolean.valueOf(true));
            } else {
                Optional.ofNullable(awsManagedAccount.getRegion()).ifPresent(arg_0 -> ((AmazonS3ClientBuilder)amazonS3ClientBuilder).setRegion(arg_0));
            }
            AmazonS3 amazonS3 = (AmazonS3)amazonS3ClientBuilder.build();
            try {
                AwsCredentials awsCredentials = new AwsCredentials();
                AwsNamedAccountCredentials.AwsNamedAccountCredentialsBuilder awsNamedAccountCredentialsBuilder = AwsNamedAccountCredentials.builder().name(name).credentials(awsCredentials);
                if (!CollectionUtils.isEmpty(supportedTypes)) {
                    if (supportedTypes.contains(AccountCredentials.Type.OBJECT_STORE)) {
                        String bucket = awsManagedAccount.getBucket();
                        String rootFolder = awsManagedAccount.getRootFolder();
                        if (StringUtils.isEmpty((Object)bucket)) {
                            throw new IllegalArgumentException("AWS/S3 account " + name + " is required to specify a bucket.");
                        }
                        if (StringUtils.isEmpty((Object)rootFolder)) {
                            throw new IllegalArgumentException("AWS/S3 account " + name + " is required to specify a rootFolder.");
                        }
                        awsNamedAccountCredentialsBuilder.bucket(bucket);
                        awsNamedAccountCredentialsBuilder.region(awsManagedAccount.getRegion());
                        awsNamedAccountCredentialsBuilder.rootFolder(rootFolder);
                        awsNamedAccountCredentialsBuilder.amazonS3(amazonS3);
                    }
                    awsNamedAccountCredentialsBuilder.supportedTypes(supportedTypes);
                }
                AwsNamedAccountCredentials awsNamedAccountCredentials = awsNamedAccountCredentialsBuilder.build();
                accountCredentialsRepository.save(name, (AccountCredentials)awsNamedAccountCredentials);
            }
            catch (Throwable t) {
                log.error("Could not load AWS account " + name + ".", t);
            }
        }
        return true;
    }
}

