/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.aws.security;

import com.amazonaws.services.s3.AmazonS3;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.kayenta.aws.security.AwsCredentials;
import com.netflix.kayenta.security.AccountCredentials;
import javax.validation.constraints.NotNull;

public class AwsNamedAccountCredentials
extends AccountCredentials<AwsCredentials> {
    @NotNull
    private AwsCredentials credentials;
    private String bucket;
    private String region;
    private String rootFolder;
    @JsonIgnore
    private AmazonS3 amazonS3;

    public String getType() {
        return "aws";
    }

    protected AwsNamedAccountCredentials(AwsNamedAccountCredentialsBuilder<?, ?> b) {
        super(b);
        this.credentials = b.credentials;
        this.bucket = b.bucket;
        this.region = b.region;
        this.rootFolder = b.rootFolder;
        this.amazonS3 = b.amazonS3;
    }

    public static AwsNamedAccountCredentialsBuilder<?, ?> builder() {
        return new AwsNamedAccountCredentialsBuilderImpl();
    }

    public AwsNamedAccountCredentials setCredentials(AwsCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public AwsNamedAccountCredentials setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public AwsNamedAccountCredentials setRegion(String region) {
        this.region = region;
        return this;
    }

    public AwsNamedAccountCredentials setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
        return this;
    }

    @JsonIgnore
    public AwsNamedAccountCredentials setAmazonS3(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
        return this;
    }

    public AwsCredentials getCredentials() {
        return this.credentials;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public AmazonS3 getAmazonS3() {
        return this.amazonS3;
    }

    public static abstract class AwsNamedAccountCredentialsBuilder<C extends AwsNamedAccountCredentials, B extends AwsNamedAccountCredentialsBuilder<C, B>>
    extends AccountCredentials.AccountCredentialsBuilder<AwsCredentials, C, B> {
        private AwsCredentials credentials;
        private String bucket;
        private String region;
        private String rootFolder;
        private AmazonS3 amazonS3;

        public B credentials(AwsCredentials credentials) {
            this.credentials = credentials;
            return (B)this.self();
        }

        public B bucket(String bucket) {
            this.bucket = bucket;
            return (B)this.self();
        }

        public B region(String region) {
            this.region = region;
            return (B)this.self();
        }

        public B rootFolder(String rootFolder) {
            this.rootFolder = rootFolder;
            return (B)this.self();
        }

        @JsonIgnore
        public B amazonS3(AmazonS3 amazonS3) {
            this.amazonS3 = amazonS3;
            return (B)this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AwsNamedAccountCredentials.AwsNamedAccountCredentialsBuilder(super=" + super.toString() + ", credentials=" + String.valueOf(this.credentials) + ", bucket=" + this.bucket + ", region=" + this.region + ", rootFolder=" + this.rootFolder + ", amazonS3=" + String.valueOf(this.amazonS3) + ")";
        }
    }

    private static final class AwsNamedAccountCredentialsBuilderImpl
    extends AwsNamedAccountCredentialsBuilder<AwsNamedAccountCredentials, AwsNamedAccountCredentialsBuilderImpl> {
        private AwsNamedAccountCredentialsBuilderImpl() {
        }

        @Override
        protected AwsNamedAccountCredentialsBuilderImpl self() {
            return this;
        }

        @Override
        public AwsNamedAccountCredentials build() {
            return new AwsNamedAccountCredentials(this);
        }
    }
}

