/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge.stats;

import com.netflix.kayenta.judge.Metric;
import com.netflix.kayenta.judge.stats.DescriptiveStatistics$;
import com.netflix.kayenta.judge.stats.MetricStatistics;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.TiesStrategy;
import org.apache.commons.math3.util.FastMath;
import scala.Array$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class EffectSizes$ {
    public static EffectSizes$ MODULE$;

    static {
        new EffectSizes$();
    }

    public double meanRatio(double[] control, double[] experiment) {
        double controlMean = StatUtils.mean((double[])control);
        double experimentMean = StatUtils.mean((double[])experiment);
        return controlMean == 0.0 || experimentMean == 0.0 ? Double.NaN : experimentMean / controlMean;
    }

    public double meanRatio(Metric control, Metric experiment) {
        return this.meanRatio(control.values(), experiment.values());
    }

    public double meanRatio(MetricStatistics control, MetricStatistics experiment) {
        return control.mean() == 0.0 || experiment.mean() == 0.0 ? Double.NaN : experiment.mean() / control.mean();
    }

    public double cohenD(Metric control, Metric experiment) {
        return this.cohenD(DescriptiveStatistics$.MODULE$.summary(control), DescriptiveStatistics$.MODULE$.summary(experiment));
    }

    public double cohenD(MetricStatistics control, MetricStatistics experiment) {
        double pooledStd = FastMath.sqrt((double)(((double)(experiment.count() - 1) * FastMath.pow((double)experiment.std(), (int)2) + (double)(control.count() - 1) * FastMath.pow((double)control.std(), (int)2)) / (double)(control.count() + experiment.count() - 2)));
        return FastMath.abs((double)(experiment.mean() - control.mean())) / pooledStd;
    }

    public double cles(double[] control, double[] experiment) {
        int m = experiment.length;
        int n = control.length;
        double[] ranks = new NaturalRanking(NaNStrategy.MAXIMAL, TiesStrategy.AVERAGE).rank((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(experiment)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(control)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        double r1 = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(ranks)).take(m))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return ((double)2 * r1 - (double)(m * (m + 1))) / (double)(2 * n * m);
    }

    public double cles(Metric control, Metric experiment) {
        return this.cles(control.values(), experiment.values());
    }

    private EffectSizes$() {
        MODULE$ = this;
    }
}

