/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge.detectors;

import com.netflix.kayenta.judge.detectors.BaseOutlierDetector;
import com.netflix.kayenta.judge.detectors.IQRDetector$;
import com.netflix.kayenta.judge.stats.DescriptiveStatistics$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001A3Aa\u0003\u0007\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011\u00159\u0003\u0001\"\u0001)\u0011\u0015a\u0003\u0001\"\u0003.\u0011\u00151\u0004\u0001\"\u00118\u000f\u001dQD\"!A\t\u0002m2qa\u0003\u0007\u0002\u0002#\u0005A\bC\u0003(\u000f\u0011\u0005\u0001\tC\u0004B\u000fE\u0005I\u0011\u0001\"\t\u000f5;\u0011\u0013!C\u0001\u001d\nY\u0011*\u0015*EKR,7\r^8s\u0015\tia\"A\u0005eKR,7\r^8sg*\u0011q\u0002E\u0001\u0006UV$w-\u001a\u0006\u0003#I\tqa[1zK:$\u0018M\u0003\u0002\u0014)\u00059a.\u001a;gY&D(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001b\u001b\u0005a\u0011BA\u000e\r\u0005M\u0011\u0015m]3PkRd\u0017.\u001a:EKR,7\r^8s\u0003\u00191\u0017m\u0019;peB\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1Ai\\;cY\u0016\f\u0011C]3ek\u000e,7+\u001a8tSRLg/\u001b;z!\tqR%\u0003\u0002'?\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u0002*U-\u0002\"!\u0007\u0001\t\u000fq\u0019\u0001\u0013!a\u0001;!91e\u0001I\u0001\u0002\u0004!\u0013\u0001D2bY\u000e,H.\u0019;f\u0013F\u0013FC\u0001\u00182!\u0011qr&H\u000f\n\u0005Az\"A\u0002+va2,'\u0007C\u00033\t\u0001\u00071'\u0001\u0003eCR\f\u0007c\u0001\u00105;%\u0011Qg\b\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0007I\u0016$Xm\u0019;\u0015\u0005aJ\u0004c\u0001\u00105I!)!'\u0002a\u0001g\u0005Y\u0011*\u0015*EKR,7\r^8s!\tIra\u0005\u0002\b{A\u0011aDP\u0005\u0003\u007f}\u0011a!\u00118z%\u00164G#A\u001e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0019%FA\u000fEW\u0005)\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003%)hn\u00195fG.,GM\u0003\u0002K?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00051;%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\u0012a\u0014\u0016\u0003I\u0011\u0003")
public class IQRDetector
extends BaseOutlierDetector {
    private final double factor;
    private final boolean reduceSensitivity;

    public static boolean $lessinit$greater$default$2() {
        return IQRDetector$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$1() {
        return IQRDetector$.MODULE$.$lessinit$greater$default$1();
    }

    private Tuple2<Object, Object> calculateIQR(double[] data) {
        double p75 = DescriptiveStatistics$.MODULE$.percentile(data, 75.0);
        double p25 = DescriptiveStatistics$.MODULE$.percentile(data, 25.0);
        double iqr = p75 - p25;
        double lowerIQR = p25 - this.factor * iqr;
        double upperIQR = p75 + this.factor * iqr;
        return new Tuple2.mcDD.sp(lowerIQR, upperIQR);
    }

    @Override
    public boolean[] detect(double[] data) {
        Tuple2.mcDD.sp sp2;
        Tuple2.mcDD.sp sp3;
        if (this.reduceSensitivity) {
            Tuple2<Object, Object> tuple2 = this.calculateIQR(data);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            double lowerIQR = tuple2._1$mcD$sp();
            double upperIQR = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(lowerIQR, upperIQR);
            Tuple2.mcDD.sp sp5 = sp4;
            double lowerIQR2 = sp5._1$mcD$sp();
            double upperIQR2 = sp5._2$mcD$sp();
            double p01 = DescriptiveStatistics$.MODULE$.percentile(data, 1.0);
            double p99 = DescriptiveStatistics$.MODULE$.percentile(data, 99.0);
            double lowerFence = package$.MODULE$.min(p01, lowerIQR2);
            double upperFence = package$.MODULE$.max(p99, upperIQR2);
            sp3 = new Tuple2.mcDD.sp(lowerFence, upperFence);
        } else {
            sp3 = sp2 = this.calculateIQR(data);
        }
        if (sp2 == null) {
            throw new MatchError(sp2);
        }
        double lowerFence = sp2._1$mcD$sp();
        double upperFence = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(lowerFence, upperFence);
        Tuple2.mcDD.sp sp7 = sp6;
        double lowerFence2 = sp7._1$mcD$sp();
        double upperFence2 = sp7._2$mcD$sp();
        return (boolean[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(data)).map((Function1)(JFunction1.mcZD.sp & java.io.Serializable & Serializable)x -> x > upperFence2 || x < lowerFence2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
    }

    public IQRDetector(double factor, boolean reduceSensitivity) {
        this.factor = factor;
        this.reduceSensitivity = reduceSensitivity;
        Predef$.MODULE$.require(factor > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "factor must be greater than zero");
    }
}

