/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge.evaluation;

import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction2;

public final class Metrics$ {
    public static Metrics$ MODULE$;

    static {
        new Metrics$();
    }

    public double truePositives(int[] y_true, int[] y_pred) {
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)y_true, (Object)y_pred)), (Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs)), (Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs))), (Function2)(JFunction2.mcDII.sp & java.io.Serializable & Serializable)(truth, pred) -> truth == 1 && pred == 1 ? 1.0 : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double falsePositives(int[] y_true, int[] y_pred) {
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)y_true, (Object)y_pred)), (Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs)), (Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs))), (Function2)(JFunction2.mcDII.sp & java.io.Serializable & Serializable)(truth, pred) -> truth == 0 && pred == 1 ? 1.0 : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double trueNegatives(int[] y_true, int[] y_pred) {
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)y_true, (Object)y_pred)), (Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs)), (Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs))), (Function2)(JFunction2.mcDII.sp & java.io.Serializable & Serializable)(truth, pred) -> truth == 0 && pred == 0 ? 1.0 : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double falseNegatives(int[] y_true, int[] y_pred) {
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)y_true, (Object)y_pred)), (Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs)), (Function1 & java.io.Serializable & Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs))), (Function2)(JFunction2.mcDII.sp & java.io.Serializable & Serializable)(truth, pred) -> truth == 1 && pred == 0 ? 1.0 : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double accuracy(int[] y_true, int[] y_pred) {
        double tp = this.truePositives(y_true, y_pred);
        double tn = this.trueNegatives(y_true, y_pred);
        double trueResults = tp + tn;
        return y_true.length < 1 ? 0.0 : trueResults / (double)y_true.length;
    }

    public double precision(int[] y_true, int[] y_pred) {
        double tp = this.truePositives(y_true, y_pred);
        double fp = this.falsePositives(y_true, y_pred);
        return tp == 0.0 && fp == 0.0 ? 0.0 : tp / (tp + fp);
    }

    public double recall(int[] y_true, int[] y_pred) {
        double tp = this.truePositives(y_true, y_pred);
        double fn = this.falseNegatives(y_true, y_pred);
        return tp == 0.0 && fn == 0.0 ? 0.0 : tp / (tp + fn);
    }

    public double truePositiveRate(int[] y_true, int[] y_pred) {
        return this.recall(y_true, y_pred);
    }

    public double falsePositiveRate(int[] y_true, int[] y_pred) {
        return 1.0 - this.trueNegativeRate(y_true, y_pred);
    }

    public double trueNegativeRate(int[] y_true, int[] y_pred) {
        double tn = this.trueNegatives(y_true, y_pred);
        double fp = this.falsePositives(y_true, y_pred);
        return fp == 0.0 && tn == 0.0 ? 0.0 : tn / (fp + tn);
    }

    public double fMeasure(int[] y_true, int[] y_pred, double beta) {
        double recall;
        double beta2 = beta * beta;
        double precision = this.precision(y_true, y_pred);
        return precision + (recall = this.recall(y_true, y_pred)) == 0.0 ? 0.0 : (1.0 + beta2) * (precision * recall) / (beta2 * precision + recall);
    }

    public double fMeasure$default$3() {
        return 1.0;
    }

    private Metrics$() {
        MODULE$ = this;
    }
}

