/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.kayenta.canary.CanaryClassifierThresholdsConfig;
import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.canary.CanaryJudge;
import com.netflix.kayenta.canary.results.CanaryJudgeResult;
import com.netflix.kayenta.judge.config.RemoteJudgeConfigurationProperties;
import com.netflix.kayenta.judge.model.RemoteJudgeRequest;
import com.netflix.kayenta.judge.service.RemoteJudgeService;
import com.netflix.kayenta.metrics.MetricSetPair;
import com.netflix.kayenta.retrofit.config.RemoteService;
import com.netflix.kayenta.retrofit.config.RetrofitClientFactory;
import com.squareup.okhttp.OkHttpClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@Component
@ConditionalOnProperty(value={"kayenta.remote-judge.enabled"})
public class RemoteJudge
extends CanaryJudge {
    private static final Logger log = LoggerFactory.getLogger(RemoteJudge.class);
    private final RetrofitClientFactory retrofitClientFactory;
    private final ObjectMapper kayentaObjectMapper;
    private final RemoteService endpoint;
    private final String JUDGE_NAME = "RemoteJudge-v1.0";

    public RemoteJudge(RetrofitClientFactory retrofitClientFactory, ObjectMapper kayentaObjectMapper, RemoteJudgeConfigurationProperties config) {
        this.retrofitClientFactory = retrofitClientFactory;
        this.kayentaObjectMapper = kayentaObjectMapper;
        this.endpoint = config.getEndpoint();
        log.info("Configured RemoteJudge-v1.0 with base URI " + this.endpoint.getBaseUrl());
    }

    public String getName() {
        return "RemoteJudge-v1.0";
    }

    public boolean isVisible() {
        return true;
    }

    public CanaryJudgeResult judge(CanaryConfig canaryConfig, CanaryClassifierThresholdsConfig scoreThresholds, List<MetricSetPair> metricSetPairList) {
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setConnectTimeout(30L, TimeUnit.SECONDS);
        okHttpClient.setReadTimeout(90L, TimeUnit.SECONDS);
        RemoteJudgeService remoteJudge = (RemoteJudgeService)this.retrofitClientFactory.createClient(RemoteJudgeService.class, (Converter)new JacksonConverter(this.kayentaObjectMapper), this.endpoint, okHttpClient);
        RemoteJudgeRequest judgeRequest = RemoteJudgeRequest.builder().canaryConfig(canaryConfig).metricSetPairList(metricSetPairList).scoreThresholds(scoreThresholds).build();
        return remoteJudge.judge(judgeRequest);
    }
}

