/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge.stats;

import com.netflix.kayenta.judge.Metric;
import com.netflix.kayenta.judge.stats.MetricStatistics;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.util.FastMath;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;

public final class DescriptiveStatistics$ {
    public static DescriptiveStatistics$ MODULE$;

    static {
        new DescriptiveStatistics$();
    }

    public double mean(Metric metric) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metric.values())).isEmpty() ? 0.0 : StatUtils.mean((double[])metric.values());
    }

    public double median(Metric metric) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metric.values())).isEmpty() ? 0.0 : StatUtils.percentile((double[])metric.values(), (double)50.0);
    }

    public double min(Metric metric) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metric.values())).isEmpty() ? 0.0 : StatUtils.min((double[])metric.values());
    }

    public double max(Metric metric) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metric.values())).isEmpty() ? 0.0 : StatUtils.max((double[])metric.values());
    }

    public double std(Metric metric) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metric.values())).isEmpty() ? 0.0 : FastMath.sqrt((double)StatUtils.variance((double[])metric.values()));
    }

    public double percentile(Metric metric, double p) {
        return this.percentile(metric.values(), p);
    }

    public double percentile(double[] values, double p) {
        Percentile percentile = new Percentile().withEstimationType(Percentile.EstimationType.R_7);
        return percentile.evaluate(values, p);
    }

    public MetricStatistics summary(Metric metric) {
        double mean = this.mean(metric);
        double min = this.min(metric);
        double max = this.max(metric);
        double std = this.std(metric);
        int count = metric.values().length;
        return new MetricStatistics(min, max, mean, std, count);
    }

    private DescriptiveStatistics$() {
        MODULE$ = this;
    }
}

