/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge;

import com.netflix.kayenta.canary.CanaryClassifierThresholdsConfig;
import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.canary.CanaryJudge;
import com.netflix.kayenta.canary.CanaryMetricConfig;
import com.netflix.kayenta.canary.results.CanaryAnalysisResult;
import com.netflix.kayenta.canary.results.CanaryJudgeResult;
import com.netflix.kayenta.judge.Metric;
import com.netflix.kayenta.judge.classifiers.metric.Error$;
import com.netflix.kayenta.judge.classifiers.metric.MannWhitneyClassifier;
import com.netflix.kayenta.judge.classifiers.metric.MetricClassification;
import com.netflix.kayenta.judge.classifiers.metric.MetricDirection;
import com.netflix.kayenta.judge.classifiers.metric.MetricDirection$;
import com.netflix.kayenta.judge.classifiers.metric.NaNStrategy;
import com.netflix.kayenta.judge.classifiers.metric.NaNStrategy$;
import com.netflix.kayenta.judge.classifiers.metric.NaNStrategy$Remove$;
import com.netflix.kayenta.judge.classifiers.metric.OutlierStrategy;
import com.netflix.kayenta.judge.classifiers.metric.OutlierStrategy$;
import com.netflix.kayenta.judge.classifiers.metric.OutlierStrategy$Remove$;
import com.netflix.kayenta.judge.config.NetflixJudgeConfigurationProperties;
import com.netflix.kayenta.judge.detectors.BaseOutlierDetector;
import com.netflix.kayenta.judge.detectors.IQRDetector;
import com.netflix.kayenta.judge.preprocessing.Transforms$;
import com.netflix.kayenta.judge.scorers.ScoringHelper;
import com.netflix.kayenta.judge.stats.DescriptiveStatistics$;
import com.netflix.kayenta.judge.stats.MetricStatistics;
import com.netflix.kayenta.judge.utils.MapUtils$;
import com.netflix.kayenta.metrics.MetricSetPair;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001\u0002\b\u0010\u0001aAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001A\u0002\u0013\u0005A\u0006C\u00044\u0001\u0001\u0007I\u0011\u0001\u001b\t\ru\u0002\u0001\u0015)\u0003.\u0011\u001di\u0005A1A\u0005\u000e9CaA\u0015\u0001!\u0002\u001by\u0005\"B*\u0001\t\u0003\"\u0006\"\u0002-\u0001\t\u0003J\u0006\"\u0002\t\u0001\t\u0003*\u0007bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a\u0015\u0001\t\u0003\t)FA\bOKR4G.\u001b=B\u0007\u0006SU\u000fZ4f\u0015\t\u0001\u0012#A\u0003kk\u0012<WM\u0003\u0002\u0013'\u000591.Y=f]R\f'B\u0001\u000b\u0016\u0003\u001dqW\r\u001e4mSbT\u0011AF\u0001\u0004G>l7\u0001A\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u0012\u0003\u0019\u0019\u0017M\\1ss&\u0011ad\u0007\u0002\f\u0007\u0006t\u0017M]=Kk\u0012<W\r\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005a1oY1mC2|wmZ5oO*\u0011A%F\u0001\tif\u0004Xm]1gK&\u0011a%\t\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005y\u0011a\t8fi\u001ad\u0017\u000e\u001f&vI\u001e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004&o\u001c9feRLWm]\u000b\u0002[A\u0011a&M\u0007\u0002_)\u0011\u0001gD\u0001\u0007G>tg-[4\n\u0005Iz#a\t(fi\u001ad\u0017\u000e\u001f&vI\u001e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004&o\u001c9feRLWm]\u0001(]\u0016$h\r\\5y\u0015V$w-Z\"p]\u001aLw-\u001e:bi&|g\u000e\u0015:pa\u0016\u0014H/[3t?\u0012*\u0017\u000f\u0006\u00026wA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t!QK\\5u\u0011\u001da4!!AA\u00025\n1\u0001\u001f\u00132\u0003\u0011rW\r\u001e4mSbTU\u000fZ4f\u0007>tg-[4ve\u0006$\u0018n\u001c8Qe>\u0004XM\u001d;jKN\u0004\u0003F\u0001\u0003@!\t\u00015*D\u0001B\u0015\t\u00115)\u0001\u0006b]:|G/\u0019;j_:T!\u0001R#\u0002\u000f\u0019\f7\r^8ss*\u0011aiR\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0011&\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u000b%!C!vi><\u0018N]3e\u0003%QW\u000fZ4f\u001d\u0006lW-F\u0001P\u001f\u0005\u0001\u0016%A)\u0002)9+GO\u001a7jq\u0006\u001b\u0015IS;eO\u0016lc/\r\u00181\u0003)QW\u000fZ4f\u001d\u0006lW\rI\u0001\nSN4\u0016n]5cY\u0016$\u0012!\u0016\t\u0003mYK!aV\u001c\u0003\u000f\t{w\u000e\\3b]\u00069q-\u001a;OC6,G#\u0001.\u0011\u0005m\u0013gB\u0001/a!\tiv'D\u0001_\u0015\tyv#\u0001\u0004=e>|GOP\u0005\u0003C^\na\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011m\u000e\u000b\u0005M2\fh\u000f\u0005\u0002hU6\t\u0001N\u0003\u0002j7\u00059!/Z:vYR\u001c\u0018BA6i\u0005E\u0019\u0015M\\1ss*+HmZ3SKN,H\u000e\u001e\u0005\u0006[&\u0001\rA\\\u0001\rG\u0006t\u0017M]=D_:4\u0017n\u001a\t\u00035=L!\u0001]\u000e\u0003\u0019\r\u000bg.\u0019:z\u0007>tg-[4\t\u000bIL\u0001\u0019A:\u0002\u001fM\u001cwN]3UQJ,7\u000f[8mIN\u0004\"A\u0007;\n\u0005U\\\"\u0001I\"b]\u0006\u0014\u0018p\u00117bgNLg-[3s)\"\u0014Xm\u001d5pY\u0012\u001c8i\u001c8gS\u001eDQa^\u0005A\u0002a\f\u0011#\\3ue&\u001c7+\u001a;QC&\u0014H*[:u!\u0011Ih0!\u0001\u000e\u0003iT!a\u001f?\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0006!!.\u0019<b\u0013\ty(P\u0001\u0003MSN$\b\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0011#A\u0004nKR\u0014\u0018nY:\n\t\u0005-\u0011Q\u0001\u0002\u000e\u001b\u0016$(/[2TKR\u0004\u0016-\u001b:\u0002\u001fQ\u0014\u0018M\\:g_JlW*\u001a;sS\u000e$\"\"!\u0005\u0002\u0018\u0005m\u0011QFA\u001c!\rQ\u00131C\u0005\u0004\u0003+y!AB'fiJL7\rC\u0004\u0002\u001a)\u0001\r!!\u0005\u0002\r5,GO]5d\u0011\u001d\tiB\u0003a\u0001\u0003?\t1B\\1o'R\u0014\u0018\r^3hsB!\u0011\u0011EA\u0015\u001b\t\t\u0019C\u0003\u0003\u0002\u001a\u0005\u0015\"bAA\u0014\u001f\u0005Y1\r\\1tg&4\u0017.\u001a:t\u0013\u0011\tY#a\t\u0003\u00179\u000bgj\u0015;sCR,w-\u001f\u0005\b\u0003_Q\u0001\u0019AA\u0019\u0003=yW\u000f\u001e7jKJ\u001cFO]1uK\u001eL\b\u0003BA\u0011\u0003gIA!!\u000e\u0002$\tyq*\u001e;mS\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010C\u0004\u0002:)\u0001\r!a\u000f\u0002\u001b=,H\u000f\\5fe\u001a\u000b7\r^8s!\r1\u0014QH\u0005\u0004\u0003\u007f9$A\u0002#pk\ndW-\u0001\u0006iC:$G.\u001a(b\u001dN$b!!\u0005\u0002F\u0005\u001d\u0003bBA\r\u0017\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003;Y\u0001\u0019AA\u0010\u00039A\u0017M\u001c3mK>+H\u000f\\5feN$\u0002\"!\u0005\u0002N\u0005=\u0013\u0011\u000b\u0005\b\u00033a\u0001\u0019AA\t\u0011\u001d\ty\u0003\u0004a\u0001\u0003cAq!!\u000f\r\u0001\u0004\tY$\u0001\bdY\u0006\u001c8/\u001b4z\u001b\u0016$(/[2\u0015\r\u0005]\u0013QLA0!\r9\u0017\u0011L\u0005\u0004\u00037B'\u0001F\"b]\u0006\u0014\u00180\u00118bYf\u001c\u0018n\u001d*fgVdG\u000fC\u0003n\u001b\u0001\u0007a\u000eC\u0004\u0002\u001a5\u0001\r!!\u0001)\u0007\u0001\t\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tIgR\u0001\u000bgR,'/Z8usB,\u0017\u0002BA7\u0003O\u0012\u0011bQ8na>tWM\u001c;")
public class NetflixACAJudge
extends CanaryJudge
implements StrictLogging {
    @Autowired
    private NetflixJudgeConfigurationProperties netflixJudgeConfigurationProperties;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public NetflixJudgeConfigurationProperties netflixJudgeConfigurationProperties() {
        return this.netflixJudgeConfigurationProperties;
    }

    public void netflixJudgeConfigurationProperties_$eq(NetflixJudgeConfigurationProperties x$1) {
        this.netflixJudgeConfigurationProperties = x$1;
    }

    private final String judgeName() {
        return "NetflixACAJudge-v1.0";
    }

    public boolean isVisible() {
        return true;
    }

    public String getName() {
        return "NetflixACAJudge-v1.0";
    }

    public CanaryJudgeResult judge(CanaryConfig canaryConfig, CanaryClassifierThresholdsConfig scoreThresholds, java.util.List<MetricSetPair> metricSetPairList) {
        List metricResults = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metricSetPairList).asScala()).toList().map((Function1 & Serializable & scala.Serializable)metricPair -> this.classifyMetric(canaryConfig, (MetricSetPair)metricPair), List$.MODULE$.canBuildFrom());
        ScoringHelper scoringHelper = new ScoringHelper("NetflixACAJudge-v1.0");
        return scoringHelper.score(canaryConfig, scoreThresholds, (List<CanaryAnalysisResult>)metricResults);
    }

    public Metric transformMetric(Metric metric, NaNStrategy nanStrategy, OutlierStrategy outlierStrategy, double outlierFactor) {
        return this.handleOutliers(this.handleNaNs(metric, nanStrategy), outlierStrategy, outlierFactor);
    }

    public Metric handleNaNs(Metric metric, NaNStrategy nanStrategy) {
        NaNStrategy naNStrategy = nanStrategy;
        NaNStrategy$Remove$ naNStrategy$Remove$ = NaNStrategy$Remove$.MODULE$;
        return !(naNStrategy != null ? !naNStrategy.equals(naNStrategy$Remove$) : naNStrategy$Remove$ != null) ? Transforms$.MODULE$.removeNaNs(metric) : Transforms$.MODULE$.replaceNaNs(metric);
    }

    public Metric handleOutliers(Metric metric, OutlierStrategy outlierStrategy, double outlierFactor) {
        Metric metric2;
        OutlierStrategy outlierStrategy2 = outlierStrategy;
        OutlierStrategy$Remove$ outlierStrategy$Remove$ = OutlierStrategy$Remove$.MODULE$;
        if (!(outlierStrategy2 != null ? !outlierStrategy2.equals(outlierStrategy$Remove$) : outlierStrategy$Remove$ != null)) {
            IQRDetector detector = new IQRDetector(outlierFactor, true);
            metric2 = Transforms$.MODULE$.removeOutliers(metric, (BaseOutlierDetector)detector);
        } else {
            metric2 = metric;
        }
        return metric2;
    }

    public CanaryAnalysisResult classifyMetric(CanaryConfig canaryConfig, MetricSetPair metric) {
        CanaryAnalysisResult canaryAnalysisResult;
        String effectSizeMeasure;
        CanaryMetricConfig config;
        Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(canaryConfig.getMetrics()).asScala()).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)NetflixACAJudge.$anonfun$classifyMetric$1(metric, m)));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(33).append("Could not find metric config for ").append(metric.getName()).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        CanaryMetricConfig canaryMetricConfig = config = (CanaryMetricConfig)some.value();
        CanaryMetricConfig metricConfig = canaryMetricConfig;
        double[] experimentValues = (double[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)metric.getValues().get("experiment")).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x$1)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        double[] controlValues = (double[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)metric.getValues().get("control")).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x$2)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        Metric experiment = new Metric(metric.getName(), experimentValues, "Canary");
        Metric control = new Metric(metric.getName(), controlValues, "Baseline");
        String directionalityString = MapUtils$.MODULE$.getAsStringWithDefault("either", metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "direction"}));
        MetricDirection directionality = MetricDirection$.MODULE$.parse(directionalityString);
        String nanStrategyString = MapUtils$.MODULE$.getAsStringWithDefault("none", metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "nanStrategy"}));
        NaNStrategy nanStrategy = NaNStrategy$.MODULE$.parse(nanStrategyString);
        String outlierStrategyString = MapUtils$.MODULE$.getAsStringWithDefault("none", metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "outliers", "strategy"}));
        OutlierStrategy outlierStrategy = OutlierStrategy$.MODULE$.parse(outlierStrategyString);
        double outlierFactor = MapUtils$.MODULE$.getAsDoubleWithDefault(3.0, metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "outliers", "outlierFactor"}));
        boolean isCriticalMetric = MapUtils$.MODULE$.getAsBooleanWithDefault(false, metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "critical"}));
        boolean isDataRequired = MapUtils$.MODULE$.getAsBooleanWithDefault(false, metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "mustHaveData"}));
        boolean isMutedMetric = MapUtils$.MODULE$.getAsBooleanWithDefault(false, metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "muted"}));
        String string = effectSizeMeasure = MapUtils$.MODULE$.getAsStringWithDefault("meanRatio", metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "effectSize", "measure"}));
        String string2 = "cles";
        double defaultEffect = !(string != null ? !string.equals(string2) : string2 != null) ? 0.5 : 1.0;
        double allowedIncrease = MapUtils$.MODULE$.getAsDoubleWithDefault(defaultEffect, metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "effectSize", "allowedIncrease"}));
        double allowedDecrease = MapUtils$.MODULE$.getAsDoubleWithDefault(defaultEffect, metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "effectSize", "allowedDecrease"}));
        Tuple2.mcDD.sp effectSizeThresholds = new Tuple2.mcDD.sp(allowedDecrease, allowedIncrease);
        double criticalIncrease = MapUtils$.MODULE$.getAsDoubleWithDefault(defaultEffect, metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "effectSize", "criticalIncrease"}));
        double criticalDecrease = MapUtils$.MODULE$.getAsDoubleWithDefault(defaultEffect, metricConfig.getAnalysisConfigurations(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"canary", "effectSize", "criticalDecrease"}));
        Tuple2.mcDD.sp criticalThresholds = new Tuple2.mcDD.sp(criticalDecrease, criticalIncrease);
        Metric transformedExperiment = this.transformMetric(experiment, nanStrategy, outlierStrategy, outlierFactor);
        Metric transformedControl = this.transformMetric(control, nanStrategy, outlierStrategy, outlierFactor);
        MetricStatistics experimentStats = DescriptiveStatistics$.MODULE$.summary(transformedExperiment);
        MetricStatistics controlStats = DescriptiveStatistics$.MODULE$.summary(transformedControl);
        MannWhitneyClassifier mannWhitney = new MannWhitneyClassifier(0.25, 0.98, (Tuple2<Object, Object>)effectSizeThresholds, (Tuple2<Object, Object>)criticalThresholds, effectSizeMeasure);
        CanaryAnalysisResult.CanaryAnalysisResultBuilder resultBuilder = CanaryAnalysisResult.builder().name(metric.getName()).id(metric.getId()).tags(metric.getTags()).groups(metricConfig.getGroups()).muted(isMutedMetric).experimentMetadata((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stats"), JavaConverters$.MODULE$.mapAsJavaMapConverter(experimentStats.toMap()).asJava())}))).asJava()).controlMetadata((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stats"), JavaConverters$.MODULE$.mapAsJavaMapConverter(controlStats.toMap()).asJava())}))).asJava());
        try {
            MetricClassification metricClassification = mannWhitney.classify(transformedControl, transformedExperiment, directionality, nanStrategy, isCriticalMetric, isDataRequired);
            canaryAnalysisResult = resultBuilder.classification(metricClassification.classification().toString()).classificationReason((String)metricClassification.reason().orNull(Predef$.MODULE$.$conforms())).critical(metricClassification.critical()).resultMetadata((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ratio"), (Object)BoxesRunTime.boxToDouble((double)metricClassification.deviation()))}))).asJava()).build();
        }
        catch (RuntimeException e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Metric Classification Failed", (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            canaryAnalysisResult = resultBuilder.classification(Error$.MODULE$.toString()).classificationReason("Metric Classification Failed").build();
        }
        return canaryAnalysisResult;
    }

    public static final /* synthetic */ boolean $anonfun$classifyMetric$1(MetricSetPair metric$1, CanaryMetricConfig m) {
        String string = m.getName();
        String string2 = metric$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public NetflixACAJudge() {
        StrictLogging.$init$((StrictLogging)this);
        this.netflixJudgeConfigurationProperties = null;
    }
}

