/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge.evaluation;

import com.netflix.kayenta.judge.classifiers.metric.BaseMetricClassifier;
import com.netflix.kayenta.judge.classifiers.metric.Error$;
import com.netflix.kayenta.judge.classifiers.metric.High$;
import com.netflix.kayenta.judge.classifiers.metric.Low$;
import com.netflix.kayenta.judge.classifiers.metric.MetricClassificationLabel;
import com.netflix.kayenta.judge.classifiers.metric.Nodata$;
import com.netflix.kayenta.judge.classifiers.metric.NodataFailMetric$;
import com.netflix.kayenta.judge.classifiers.metric.Pass$;
import com.netflix.kayenta.judge.evaluation.BaseEvaluator;
import com.netflix.kayenta.judge.evaluation.LabeledInstance;
import com.netflix.kayenta.judge.evaluation.Metrics$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4AAB\u0004\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C\u00057!)!\u0006\u0001C\u0001W!)\u0011\t\u0001C\u0001\u0005\")Q\n\u0001C!\u001d\ni\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'O\u0003\u0002\t\u0013\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005)Y\u0011!\u00026vI\u001e,'B\u0001\u0007\u000e\u0003\u001dY\u0017-_3oi\u0006T!AD\b\u0002\u000f9,GO\u001a7jq*\t\u0001#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u000f%\u0011ac\u0002\u0002\u000e\u0005\u0006\u001cX-\u0012<bYV\fGo\u001c:\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000b\u0001\u0003)1\u0018\r\\5e\u0013:\u0004X\u000f\u001e\u000b\u00039\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011qAQ8pY\u0016\fg\u000eC\u0003$\u0005\u0001\u0007A%A\u0003j]B,H\u000fE\u0002\u001eK\u001dJ!A\n\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005uA\u0013BA\u0015\u001f\u0005\rIe\u000e^\u0001\u0011G\u0006d7-\u001e7bi\u0016lU\r\u001e:jGN$2\u0001L\u001f@!\u0011iCg\u000e\u001e\u000f\u00059\u0012\u0004CA\u0018\u001f\u001b\u0005\u0001$BA\u0019\u0012\u0003\u0019a$o\\8u}%\u00111GH\u0001\u0007!J,G-\u001a4\n\u0005U2$aA'ba*\u00111G\b\t\u0003[aJ!!\u000f\u001c\u0003\rM#(/\u001b8h!\ti2(\u0003\u0002==\t1Ai\\;cY\u0016DQAP\u0002A\u0002\u0011\nQ\u0001\u001e:vi\"DQ\u0001Q\u0002A\u0002\u0011\n1\u0002\u001d:fI&\u001cG/[8og\u0006a1m\u001c8wKJ$H*\u00192fYR\u0011qe\u0011\u0005\u0006\t\u0012\u0001\r!R\u0001\u0006Y\u0006\u0014W\r\u001c\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000ba!\\3ue&\u001c'B\u0001&\n\u0003-\u0019G.Y:tS\u001aLWM]:\n\u00051;%!G'fiJL7m\u00117bgNLg-[2bi&|g\u000eT1cK2\f\u0001\"\u001a<bYV\fG/Z\u000b\u0003\u001fR#2\u0001\f)^\u0011\u0015\tV\u00011\u0001S\u0003)\u0019G.Y:tS\u001aLWM\u001d\t\u0003'Rc\u0001\u0001B\u0003V\u000b\t\u0007aKA\u0001U#\t9&\f\u0005\u0002\u001e1&\u0011\u0011L\b\u0002\b\u001d>$\b.\u001b8h!\t15,\u0003\u0002]\u000f\n!\")Y:f\u001b\u0016$(/[2DY\u0006\u001c8/\u001b4jKJDQAX\u0003A\u0002}\u000bq\u0001Z1uCN,G\u000fE\u0002aK\"t!!Y2\u000f\u0005=\u0012\u0017\"A\u0010\n\u0005\u0011t\u0012a\u00029bG.\fw-Z\u0005\u0003M\u001e\u0014A\u0001T5ti*\u0011AM\b\t\u0003)%L!A[\u0004\u0003\u001f1\u000b'-\u001a7fI&s7\u000f^1oG\u0016\u0004")
public class BinaryClassificationEvaluator
extends BaseEvaluator {
    private boolean validInput(int[] input) {
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(input)).contains((Object)BoxesRunTime.boxToInteger((int)0)) || new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(input)).contains((Object)BoxesRunTime.boxToInteger((int)1));
    }

    public Map<String, Object> calculateMetrics(int[] truth, int[] predictions) {
        Predef$.MODULE$.require(predictions.length == truth.length, (Function0 & Serializable & scala.Serializable)() -> "the prediction vector and truth vector must be the same size");
        Predef$.MODULE$.require(this.validInput(predictions) && this.validInput(truth), (Function0 & Serializable & scala.Serializable)() -> "the prediction or truth vectors contain invalid entries");
        double precision = Metrics$.MODULE$.precision(truth, predictions);
        double recall = Metrics$.MODULE$.recall(truth, predictions);
        double f1 = Metrics$.MODULE$.fMeasure(truth, predictions, Metrics$.MODULE$.fMeasure$default$3());
        double accuracy = Metrics$.MODULE$.accuracy(truth, predictions);
        return ((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Precision", (Object)BoxesRunTime.boxToDouble((double)precision)), new Tuple2((Object)"Recall", (Object)BoxesRunTime.boxToDouble((double)recall)), new Tuple2((Object)"FMeasure", (Object)BoxesRunTime.boxToDouble((double)f1)), new Tuple2((Object)"Accuracy", (Object)BoxesRunTime.boxToDouble((double)accuracy))}))).withDefaultValue((Object)BoxesRunTime.boxToDouble((double)-1.0));
    }

    public int convertLabel(MetricClassificationLabel label) {
        int n;
        MetricClassificationLabel metricClassificationLabel = label;
        if (High$.MODULE$.equals(metricClassificationLabel)) {
            n = 1;
        } else if (Low$.MODULE$.equals(metricClassificationLabel)) {
            n = 1;
        } else if (NodataFailMetric$.MODULE$.equals(metricClassificationLabel)) {
            n = 1;
        } else if (Nodata$.MODULE$.equals(metricClassificationLabel)) {
            n = 0;
        } else if (Pass$.MODULE$.equals(metricClassificationLabel)) {
            n = 0;
        } else if (Error$.MODULE$.equals(metricClassificationLabel)) {
            n = -1;
        } else {
            throw new MatchError((Object)metricClassificationLabel);
        }
        return n;
    }

    @Override
    public <T extends BaseMetricClassifier> Map<String, Object> evaluate(T classifier, List<LabeledInstance> dataset) {
        List truth = (List)dataset.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)this.convertLabel(x.label())), List$.MODULE$.canBuildFrom());
        List predictions = (List)dataset.map((Function1 & Serializable & scala.Serializable)x -> classifier.classify(x.control(), x.experiment(), classifier.classify$default$3(), classifier.classify$default$4(), classifier.classify$default$5(), classifier.classify$default$6()).classification(), List$.MODULE$.canBuildFrom());
        List binaryPredictions = (List)predictions.map((Function1 & Serializable & scala.Serializable)label -> BoxesRunTime.boxToInteger((int)this.convertLabel(label)), List$.MODULE$.canBuildFrom());
        return this.calculateMetrics((int[])truth.toArray(ClassTag$.MODULE$.Int()), (int[])binaryPredictions.toArray(ClassTag$.MODULE$.Int()));
    }
}

