/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge.model;

import com.netflix.kayenta.canary.CanaryClassifierThresholdsConfig;
import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.metrics.MetricSetPair;
import java.util.List;
import javax.validation.constraints.NotNull;

public class RemoteJudgeRequest {
    @NotNull
    private CanaryConfig canaryConfig;
    @NotNull
    private CanaryClassifierThresholdsConfig scoreThresholds;
    @NotNull
    private List<MetricSetPair> metricSetPairList;

    RemoteJudgeRequest(CanaryConfig canaryConfig, CanaryClassifierThresholdsConfig scoreThresholds, List<MetricSetPair> metricSetPairList) {
        this.canaryConfig = canaryConfig;
        this.scoreThresholds = scoreThresholds;
        this.metricSetPairList = metricSetPairList;
    }

    public static RemoteJudgeRequestBuilder builder() {
        return new RemoteJudgeRequestBuilder();
    }

    public CanaryConfig getCanaryConfig() {
        return this.canaryConfig;
    }

    public CanaryClassifierThresholdsConfig getScoreThresholds() {
        return this.scoreThresholds;
    }

    public List<MetricSetPair> getMetricSetPairList() {
        return this.metricSetPairList;
    }

    public static class RemoteJudgeRequestBuilder {
        private CanaryConfig canaryConfig;
        private CanaryClassifierThresholdsConfig scoreThresholds;
        private List<MetricSetPair> metricSetPairList;

        RemoteJudgeRequestBuilder() {
        }

        public RemoteJudgeRequestBuilder canaryConfig(CanaryConfig canaryConfig) {
            this.canaryConfig = canaryConfig;
            return this;
        }

        public RemoteJudgeRequestBuilder scoreThresholds(CanaryClassifierThresholdsConfig scoreThresholds) {
            this.scoreThresholds = scoreThresholds;
            return this;
        }

        public RemoteJudgeRequestBuilder metricSetPairList(List<MetricSetPair> metricSetPairList) {
            this.metricSetPairList = metricSetPairList;
            return this;
        }

        public RemoteJudgeRequest build() {
            return new RemoteJudgeRequest(this.canaryConfig, this.scoreThresholds, this.metricSetPairList);
        }

        public String toString() {
            return "RemoteJudgeRequest.RemoteJudgeRequestBuilder(canaryConfig=" + String.valueOf(this.canaryConfig) + ", scoreThresholds=" + String.valueOf(this.scoreThresholds) + ", metricSetPairList=" + String.valueOf(this.metricSetPairList) + ")";
        }
    }
}

