/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.judge.scorers;

import com.netflix.kayenta.canary.results.CanaryAnalysisResult;
import com.netflix.kayenta.judge.classifiers.metric.High$;
import com.netflix.kayenta.judge.classifiers.metric.Low$;
import com.netflix.kayenta.judge.classifiers.metric.Nodata$;
import com.netflix.kayenta.judge.classifiers.metric.NodataFailMetric$;
import com.netflix.kayenta.judge.classifiers.metric.Pass$;
import com.netflix.kayenta.judge.scorers.BaseScorer;
import com.netflix.kayenta.judge.scorers.GroupScore;
import com.netflix.kayenta.judge.scorers.ScoreResult;
import java.io.Serializable;
import org.apache.commons.math3.util.Precision;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000194Aa\u0003\u0007\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u00032\u0001\u0011\u0005!\u0007C\u00046\u0001\t\u0007I\u0011\u0001\u001c\t\ri\u0002\u0001\u0015!\u00038\u0011\u0015Y\u0004\u0001\"\u0003=\u0011\u0015i\u0005\u0001\"\u0003O\u0011\u0015Y\u0006\u0001\"\u0003]\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015A\u0007\u0001\"\u0011j\u0005E9V-[4ii\u0016$7+^7TG>\u0014XM\u001d\u0006\u0003\u001b9\tqa]2pe\u0016\u00148O\u0003\u0002\u0010!\u0005)!.\u001e3hK*\u0011\u0011CE\u0001\bW\u0006LXM\u001c;b\u0015\t\u0019B#A\u0004oKR4G.\u001b=\u000b\u0003U\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eQR\"\u0001\u0007\n\u0005ma!A\u0003\"bg\u0016\u001c6m\u001c:fe\u0006aqM]8va^+\u0017n\u001a5ugB!ad\n\u0016.\u001d\tyR\u0005\u0005\u0002!G5\t\u0011E\u0003\u0002#-\u00051AH]8pizR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\ri\u0015\r\u001d\u0006\u0003M\r\u0002\"AH\u0016\n\u00051J#AB*ue&tw\r\u0005\u0002/_5\t1%\u0003\u00021G\t1Ai\\;cY\u0016\fa\u0001P5oSRtDCA\u001a5!\tI\u0002\u0001C\u0003\u001d\u0005\u0001\u0007Q$\u0001\tO\u001f\u0012\u000bE+Q0U\u0011J+5\u000bS(M\tV\tq\u0007\u0005\u0002/q%\u0011\u0011h\t\u0002\u0004\u0013:$\u0018!\u0005(P\t\u0006#\u0016i\u0018+I%\u0016\u001b\u0006j\u0014'EA\u0005\u00192-\u00197dk2\fG/Z$s_V\u00048kY8sKR\u0019Q\b\u0011\"\u0011\u0005eq\u0014BA \r\u0005)9%o\\;q'\u000e|'/\u001a\u0005\u0006\u0003\u0016\u0001\rAK\u0001\nOJ|W\u000f\u001d(b[\u0016DQaQ\u0003A\u0002\u0011\u000bAc\u00197bgNLg-[2bi&|g\u000eT1cK2\u001c\bcA#KU9\u0011a\t\u0013\b\u0003A\u001dK\u0011\u0001J\u0005\u0003\u0013\u000e\nq\u0001]1dW\u0006<W-\u0003\u0002L\u0019\n!A*[:u\u0015\tI5%\u0001\u000bdC2\u001cW\u000f\\1uK\u001e\u0013x.\u001e9TG>\u0014Xm\u001d\u000b\u0003\u001fB\u00032!\u0012&>\u0011\u0015\tf\u00011\u0001S\u00035iW\r\u001e:jGJ+7/\u001e7ugB\u0019QIS*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016a\u0002:fgVdGo\u001d\u0006\u00031B\taaY1oCJL\u0018B\u0001.V\u0005Q\u0019\u0015M\\1ss\u0006s\u0017\r\\=tSN\u0014Vm];mi\u0006)2-\u00197dk2\fG/Z*v[6\f'/_*d_J,GCA\u0017^\u0011\u0015qv\u00011\u0001P\u000319'o\\;q%\u0016\u001cX\u000f\u001c;t\u0003A\u0019'/\u001b;jG\u0006dg)Y5mkJ,7\u000f\u0006\u0002SC\")a\u000b\u0003a\u0001%\u0006iAo\\8NC:Lhj\u001c3bi\u0006$\"\u0001Z4\u0011\u00059*\u0017B\u00014$\u0005\u001d\u0011un\u001c7fC:DQAV\u0005A\u0002I\u000bQa]2pe\u0016$\"A[7\u0011\u0005eY\u0017B\u00017\r\u0005-\u00196m\u001c:f%\u0016\u001cX\u000f\u001c;\t\u000bYS\u0001\u0019\u0001*")
public class WeightedSumScorer
extends BaseScorer {
    private final Map<String, Object> groupWeights;
    private final int NODATA_THRESHOLD;

    public int NODATA_THRESHOLD() {
        return this.NODATA_THRESHOLD;
    }

    private GroupScore calculateGroupScore(String groupName, List<String> classificationLabels) {
        int numMissingRequiredData;
        int numLow;
        Map labelCounts = classificationLabels.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()));
        int numMetrics = classificationLabels.size();
        int numPass = BoxesRunTime.unboxToInt((Object)labelCounts.getOrElse((Object)Pass$.MODULE$.toString(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int numHigh = BoxesRunTime.unboxToInt((Object)labelCounts.getOrElse((Object)High$.MODULE$.toString(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int numTotal = numHigh + (numLow = BoxesRunTime.unboxToInt((Object)labelCounts.getOrElse((Object)Low$.MODULE$.toString(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))) + numPass + (numMissingRequiredData = BoxesRunTime.unboxToInt((Object)labelCounts.getOrElse((Object)NodataFailMetric$.MODULE$.toString(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
        boolean hasNoData = numTotal == 0;
        double score = hasNoData ? 0.0 : (double)numPass / (double)numTotal * (double)100;
        return new GroupScore(groupName, score, hasNoData, (Map<String, Object>)labelCounts, numMetrics);
    }

    private List<GroupScore> calculateGroupScores(List<CanaryAnalysisResult> metricResults) {
        Map groupLabels = ((TraversableLike)metricResults.flatMap((Function1 & Serializable & scala.Serializable)metric -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metric.getGroups()).asScala()).map((Function1 & Serializable & scala.Serializable)group -> new Tuple2(group, (Object)metric.getClassification()), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1()).mapValues((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._2(), List$.MODULE$.canBuildFrom()));
        return ((TraversableOnce)groupLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String groupName = (String)tuple2._1();
            List labels = (List)tuple2._2();
            GroupScore groupScore = this.calculateGroupScore(groupName, (List<String>)labels);
            return groupScore;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    private double calculateSummaryScore(List<GroupScore> groupResults) {
        double groupWeightSum = BoxesRunTime.unboxToDouble((Object)this.groupWeights.values().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        Set groupWeightSet = this.groupWeights.keySet();
        Set groupSet = ((TraversableOnce)groupResults.map((Function1 & Serializable & scala.Serializable)group -> group.name(), List$.MODULE$.canBuildFrom())).toSet();
        Set groupDifference = (Set)groupSet.diff((GenSet)groupWeightSet);
        double calculatedWeight = groupDifference.nonEmpty() ? ((double)100 - groupWeightSum) / (double)groupDifference.size() : 0.0;
        DoubleRef summaryScore = DoubleRef.create((double)0.0);
        groupResults.foreach((Function1 & Serializable & scala.Serializable)group -> {
            WeightedSumScorer.$anonfun$calculateSummaryScore$2(this, calculatedWeight, summaryScore, group);
            return BoxedUnit.UNIT;
        });
        return Precision.round((double)summaryScore.elem, (int)2);
    }

    public List<CanaryAnalysisResult> criticalFailures(List<CanaryAnalysisResult> results) {
        return (List)results.filter((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)WeightedSumScorer.$anonfun$criticalFailures$1(result)));
    }

    public boolean tooManyNodata(List<CanaryAnalysisResult> results) {
        List nodata = (List)results.filter((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)WeightedSumScorer.$anonfun$tooManyNodata$1(result)));
        double nodataPercent = (double)nodata.size() / (double)results.size() * (double)100;
        return nodataPercent >= (double)this.NODATA_THRESHOLD();
    }

    @Override
    public ScoreResult score(List<CanaryAnalysisResult> results) {
        ScoreResult scoreResult;
        List<GroupScore> groupScores = this.calculateGroupScores(results);
        List<CanaryAnalysisResult> failures = this.criticalFailures(results);
        if (failures.nonEmpty()) {
            String reason = new StringBuilder(15).append("Canary Failed: ").append(((CanaryAnalysisResult)failures.head()).getClassificationReason()).toString();
            scoreResult = new ScoreResult((Option<List<GroupScore>>)new Some(groupScores), 0.0, results.size(), (Option<String>)new Some((Object)reason));
        } else if (this.tooManyNodata(results)) {
            String reason = new StringBuilder(42).append("Canary Failed: ").append(this.NODATA_THRESHOLD()).append("% or more metrics returned ").append(Nodata$.MODULE$.toString().toUpperCase()).toString();
            scoreResult = new ScoreResult((Option<List<GroupScore>>)new Some(groupScores), 0.0, results.size(), (Option<String>)new Some((Object)reason));
        } else {
            double summaryScore = this.calculateSummaryScore(groupScores);
            scoreResult = new ScoreResult((Option<List<GroupScore>>)new Some(groupScores), summaryScore, results.size(), (Option<String>)None$.MODULE$);
        }
        return scoreResult;
    }

    public static final /* synthetic */ void $anonfun$calculateSummaryScore$2(WeightedSumScorer $this, double calculatedWeight$1, DoubleRef summaryScore$1, GroupScore group) {
        double effectiveScore = group.noData() ? 100.0 : group.score();
        double weight = BoxesRunTime.unboxToDouble((Object)$this.groupWeights.getOrElse((Object)group.name(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> calculatedWeight$1));
        summaryScore$1.elem += effectiveScore * (weight / (double)100);
    }

    public static final /* synthetic */ boolean $anonfun$criticalFailures$1(CanaryAnalysisResult result) {
        return result.isCritical() && !result.getClassification().equals(Pass$.MODULE$.toString());
    }

    public static final /* synthetic */ boolean $anonfun$tooManyNodata$1(CanaryAnalysisResult result) {
        return result.getClassification().equals(Nodata$.MODULE$.toString());
    }

    public WeightedSumScorer(Map<String, Object> groupWeights) {
        this.groupWeights = groupWeights;
        this.NODATA_THRESHOLD = 50;
    }
}

