/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.mannwhitney;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.util.Precision;

public class BrentSolver {
    private static final int MAX_ITERATIONS = 1000;
    private static final double TOLERANCE = 1.0E-4;
    private static final double EPSILON = 2.220446049250313E-16;

    static double solve(double ax, double bx, double fa, double fb, UnivariateFunction func) {
        int iteration = 1001;
        double a = ax;
        double b = bx;
        double c = a;
        double fc = fa;
        if (Precision.equals((double)fa, (double)0.0)) {
            return a;
        }
        if (Precision.equals((double)fb, (double)0.0)) {
            return b;
        }
        while (iteration-- > 0) {
            double prev_step = b - a;
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol_act = 4.440892098500626E-16 * Math.abs(b) + 5.0E-5;
            double new_step = (c - b) / 2.0;
            if (Math.abs(new_step) <= tol_act || Precision.equals((double)fb, (double)0.0)) {
                return b;
            }
            if (Math.abs(prev_step) >= tol_act && Math.abs(fa) > Math.abs(fb)) {
                double q;
                double p;
                double cb = c - b;
                if (a == c) {
                    t1 = fb / fa;
                    p = cb * t1;
                    q = 1.0 - t1;
                } else {
                    q = fa / fc;
                    t1 = fb / fc;
                    double t2 = fb / fa;
                    p = t2 * (cb * q * (q - t1) - (b - a) * (t1 - 1.0));
                    q = (q - 1.0) * (t1 - 1.0) * (t2 - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                if (p < 0.75 * cb * q - Math.abs(tol_act * q) / 2.0 && p < Math.abs(prev_step * q / 2.0)) {
                    new_step = p / q;
                }
            }
            if (Math.abs(new_step) < tol_act) {
                new_step = new_step > 0.0 ? tol_act : -tol_act;
            }
            a = b;
            fa = fb;
            fb = func.value(b += new_step);
            if (!(fb > 0.0 && fc > 0.0) && (!(fb < 0.0) || !(fc < 0.0))) continue;
            c = a;
            fc = fa;
        }
        return b;
    }
}

