/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.mannwhitney;

import com.netflix.kayenta.mannwhitney.BrentSolver;
import com.netflix.kayenta.mannwhitney.MannWhitneyParams;
import com.netflix.kayenta.mannwhitney.MannWhitneyResult;
import java.io.Serializable;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.TiesStrategy;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q3A\u0001C\u0005\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!9\u0001\u0007AI\u0001\n\u0003\t\u0004b\u0002\u001f\u0001#\u0003%\t!\r\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u0019\u0002!\t!\u0014\u0005\u0006'\u0002!\t\u0002\u0016\u0002\f\u001b\u0006tgn\u00165ji:,\u0017P\u0003\u0002\u000b\u0017\u0005YQ.\u00198oo\"LGO\\3z\u0015\taQ\"A\u0004lCf,g\u000e^1\u000b\u00059y\u0011a\u00028fi\u001ad\u0017\u000e\u001f\u0006\u0002!\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005I\u0011\u0001E7b]:<\u0006.\u001b;oKf,F+Z:u)\u0015y\"E\u000b\u0017/!\ta\u0002%\u0003\u0002\"\u0013\t\tR*\u00198o/\"LGO\\3z%\u0016\u001cX\u000f\u001c;\t\u000b\r\u0012\u0001\u0019\u0001\u0013\u0002\u0003a\u00042\u0001F\u0013(\u0013\t1SCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0015Q%\u0011\u0011&\u0006\u0002\u0007\t>,(\r\\3\t\u000b-\u0012\u0001\u0019\u0001\u0013\u0002\u0003eDq!\f\u0002\u0011\u0002\u0003\u0007q%A\bd_:4\u0017\u000eZ3oG\u0016dUM^3m\u0011\u001dy#\u0001%AA\u0002\u001d\n!!\\;\u000255\fgN\\,iSRtW-_+UKN$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003IR#aJ\u001a,\u0003Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u0013Ut7\r[3dW\u0016$'BA\u001d\u0016\u0003)\tgN\\8uCRLwN\\\u0005\u0003wY\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003ii\u0017M\u001c8XQ&$h.Z=V)\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003\u0011)g/\u00197\u0015\u0005}y\u0004\"\u0002!\u0006\u0001\u0004\t\u0015A\u00029be\u0006l7\u000f\u0005\u0002\u001d\u0005&\u00111)\u0003\u0002\u0012\u001b\u0006tgn\u00165ji:,\u0017\u0010U1sC6\u001c\b\u0006B\u0003F\u0011*\u0003\"\u0001\u0006$\n\u0005\u001d+\"A\u00033faJ,7-\u0019;fI\u0006\n\u0011*A\u000fVg\u0016\u0004S.\u00198o/\"LGO\\3z+R+7\u000f\u001e\u0011j]N$X-\u00193/C\u0005Y\u0015!\u0002\u001a/s9\u0002\u0014\u0001D<jY\u000e|\u0007p\u001c8ES\u001a4G#B\u0014O\u001fF\u0013\u0006\"B\u0018\u0007\u0001\u00049\u0003\"\u0002)\u0007\u0001\u00049\u0013\u0001C9vC:$\u0018\u000e\\3\t\u000b\r2\u0001\u0019\u0001\u0013\t\u000b-2\u0001\u0019\u0001\u0013\u00027\r\fGnY;mCR,7i\u001c8gS\u0012,gnY3J]R,'O^1m)\u0015)\u0006,\u0017.\\!\u0011!b\u000bJ\u0014\n\u0005]+\"A\u0002+va2,'\u0007C\u0003$\u000f\u0001\u0007A\u0005C\u0003,\u000f\u0001\u0007A\u0005C\u0003.\u000f\u0001\u0007q\u0005C\u00030\u000f\u0001\u0007q\u0005")
public class MannWhitney {
    public MannWhitneyResult mannWhitneyUTest(double[] x, double[] y, double confidenceLevel, double mu) {
        Tuple2<double[], Object> tuple2 = this.calculateConfidenceInterval(x, y, confidenceLevel, mu);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double[] confidenceInterval = (double[])tuple2._1();
        double estimate = tuple2._2$mcD$sp();
        Tuple2 tuple22 = new Tuple2((Object)confidenceInterval, (Object)BoxesRunTime.boxToDouble((double)estimate));
        Tuple2 tuple23 = tuple22;
        double[] confidenceInterval2 = (double[])tuple23._1();
        double estimate2 = tuple23._2$mcD$sp();
        return new MannWhitneyResult(confidenceInterval2, estimate2);
    }

    public double mannWhitneyUTest$default$3() {
        return 0.95;
    }

    public double mannWhitneyUTest$default$4() {
        return 0.0;
    }

    public synchronized MannWhitneyResult eval(MannWhitneyParams params) {
        Tuple2<double[], Object> tuple2 = this.calculateConfidenceInterval(params.experimentData(), params.controlData(), params.confidenceLevel(), params.mu());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double[] confidenceInterval = (double[])tuple2._1();
        double estimate = tuple2._2$mcD$sp();
        Tuple2 tuple22 = new Tuple2((Object)confidenceInterval, (Object)BoxesRunTime.boxToDouble((double)estimate));
        Tuple2 tuple23 = tuple22;
        double[] confidenceInterval2 = (double[])tuple23._1();
        double estimate2 = tuple23._2$mcD$sp();
        return new MannWhitneyResult(confidenceInterval2, estimate2);
    }

    public double wilcoxonDiff(double mu, double quantile, double[] x2, double[] y) {
        double xLen = x2.length;
        double yLen = y.length;
        double[] dr = new NaturalRanking(NaNStrategy.MAXIMAL, TiesStrategy.AVERAGE).rank((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x2)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> x$3 - mu, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(y)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        Map ntiesCi = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(dr)).groupBy((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToDouble((double)x)))).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)MannWhitney.$anonfun$wilcoxonDiff$3(x$4)));
        double dz = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x2)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)e -> dr[e], IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) - xLen * (xLen + 1.0) / (double)2 - xLen * yLen / (double)2;
        double correctionCi = (double)(Predef$.MODULE$.float2Float((float)RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(dz))).isNaN() ? 0 : RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(dz))) * 0.5;
        double sigmaCi = Math.sqrt(xLen * yLen / (double)12 * (xLen + yLen + 1.0 - BoxesRunTime.unboxToDouble((Object)ntiesCi.mapValues((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)v -> Math.pow(v, 3.0) - (double)v).values().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / ((xLen + yLen) * (xLen + yLen - 1.0))));
        if (sigmaCi == 0.0) {
            throw new IllegalArgumentException("cannot compute confidence interval when all observations are tied");
        }
        return (dz - correctionCi) / sigmaCi - quantile;
    }

    public Tuple2<double[], Object> calculateConfidenceInterval(double[] x, double[] y, double confidenceLevel, double mu) {
        double alpha = 1.0 - confidenceLevel;
        double muMin = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).min((Ordering)Ordering.Double$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(y)).max((Ordering)Ordering.Double$.MODULE$));
        double muMax = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).max((Ordering)Ordering.Double$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(y)).min((Ordering)Ordering.Double$.MODULE$));
        Function1 & Serializable & scala.Serializable wilcoxonDiffWrapper = (Function1 & Serializable & scala.Serializable)zq -> MannWhitney.$anonfun$calculateConfidenceInterval$1(this, x, y, BoxesRunTime.unboxToDouble((Object)zq));
        double zQuant = new NormalDistribution(0.0, 1.0).inverseCumulativeProbability(alpha / (double)2);
        double[] confidenceInterval = new double[]{this.findRoot$1(-zQuant, muMin, x, y, muMax, wilcoxonDiffWrapper), this.findRoot$1(zQuant, muMin, x, y, muMax, wilcoxonDiffWrapper)};
        double fLower = this.wilcoxonDiff(muMin, 0.0, x, y);
        double fUpper = this.wilcoxonDiff(muMax, 0.0, x, y);
        double estimate = BrentSolver.solve(muMin, muMax, fLower, fUpper, (UnivariateFunction)wilcoxonDiffWrapper.apply((Object)BoxesRunTime.boxToDouble((double)0.0)));
        return new Tuple2((Object)confidenceInterval, (Object)BoxesRunTime.boxToDouble((double)estimate));
    }

    public static final /* synthetic */ int $anonfun$wilcoxonDiff$3(double[] x$4) {
        return x$4.length;
    }

    public static final /* synthetic */ UnivariateFunction $anonfun$calculateConfidenceInterval$1(MannWhitney $this, double[] x$5, double[] y$1, double zq) {
        return new UnivariateFunction($this, zq, x$5, y$1){
            private final /* synthetic */ MannWhitney $outer;
            private final double zq$1;
            private final double[] x$5;
            private final double[] y$1;

            public double value(double input) {
                return this.$outer.wilcoxonDiff(input, this.zq$1, this.x$5, this.y$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.zq$1 = zq$1;
                this.x$5 = x$5;
                this.y$1 = y$1;
            }
        };
    }

    private final double findRoot$1(double zq, double muMin$1, double[] x$5, double[] y$1, double muMax$1, Function1 wilcoxonDiffWrapper$1) {
        double fLower = this.wilcoxonDiff(muMin$1, zq, x$5, y$1);
        double fUpper = this.wilcoxonDiff(muMax$1, zq, x$5, y$1);
        return fLower <= 0.0 ? muMin$1 : (fUpper >= 0.0 ? muMax$1 : BrentSolver.solve(muMin$1, muMax$1, fLower, fUpper, (UnivariateFunction)wilcoxonDiffWrapper$1.apply((Object)BoxesRunTime.boxToDouble((double)zq))));
    }
}

