/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthContributor;

public class OrcaCompositeHealthContributor
implements CompositeHealthContributor {
    private final StatusAggregator statusAggregator;
    private final Map<String, NamedContributor<HealthContributor>> contributors;

    public OrcaCompositeHealthContributor(StatusAggregator statusAggregator, HealthContributorRegistry healthContributorRegistry) {
        this.statusAggregator = statusAggregator;
        this.contributors = new LinkedHashMap<String, NamedContributor<HealthContributor>>();
        healthContributorRegistry.forEach(contributor -> this.contributors.put(contributor.getName(), (NamedContributor<HealthContributor>)NamedContributor.of((String)contributor.getName(), (Object)((HealthContributor)contributor.getContributor()))));
    }

    public HealthContributor getContributor(String name) {
        return (HealthContributor)this.contributors.get(name).getContributor();
    }

    public Stream<NamedContributor<HealthContributor>> stream() {
        return super.stream();
    }

    @NotNull
    public Iterator<NamedContributor<HealthContributor>> iterator() {
        return this.contributors.values().iterator();
    }

    public void forEach(Consumer<? super NamedContributor<HealthContributor>> action) {
        super.forEach(action);
    }

    public Spliterator<NamedContributor<HealthContributor>> spliterator() {
        return super.spliterator();
    }

    public Status status() {
        Set statuses = this.contributors.values().stream().filter(c -> c.getContributor() instanceof HealthIndicator).map(contributor -> ((HealthIndicator)contributor.getContributor()).getHealth(false)).map(Health::getStatus).collect(Collectors.toSet());
        statuses.addAll(this.getDiscoveryStatuses());
        return this.statusAggregator.getAggregateStatus(statuses);
    }

    private Set<Status> getDiscoveryStatuses() {
        NamedContributor<HealthContributor> discoveryComposite = this.contributors.get("discoveryComposite");
        if (discoveryComposite != null) {
            return ((DiscoveryCompositeHealthContributor)discoveryComposite.getContributor()).getIndicators().values().stream().map(i -> i.health().getStatus()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

