/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.config;

import com.netflix.spinnaker.config.QueueConfiguration;
import com.netflix.spinnaker.orca.config.RedisConfiguration;
import com.netflix.spinnaker.orca.exceptions.DefaultExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.RestrictExecutionDuringTimeWindow;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import java.net.InetAddress;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={com.netflix.spinnaker.orca.config.OrcaConfiguration.class, PropertyPlaceholderAutoConfiguration.class, QueueConfiguration.class, RedisConfiguration.class, RestrictExecutionDuringTimeWindow.class, StageNavigator.class})
@ComponentScan(value={"com.netflix.kayenta.orca", "com.netflix.spinnaker.orca.pipeline"})
public class OrcaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OrcaConfiguration.class);

    @Bean
    String currentInstanceId() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            log.info("Kayenta hostname is " + hostname);
        }
        catch (Exception e) {
            hostname = "UNKNOWN";
            log.warn("Failed to determine Kayenta hostname", (Throwable)e);
        }
        String currentInstanceId = UUID.randomUUID() + "@" + hostname;
        return currentInstanceId;
    }

    @Bean
    ContextParameterProcessor contextParameterProcessor() {
        return new ContextParameterProcessor();
    }

    @Bean
    DefaultExceptionHandler defaultExceptionHandler() {
        return new DefaultExceptionHandler();
    }
}

