/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.orca.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.kayenta.config.OrcaCompositeHealthContributor;
import com.netflix.spinnaker.kork.discovery.DiscoveryStatusChangeEvent;
import com.netflix.spinnaker.kork.discovery.InstanceStatus;
import com.netflix.spinnaker.kork.discovery.RemoteStatusChangedEvent;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.pipeline.ExecutionLauncher;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.ScheduledAnnotationBeanPostProcessor;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pipelines"})
public class PipelineController {
    private static final Logger log = LoggerFactory.getLogger(PipelineController.class);
    private final ExecutionLauncher executionLauncher;
    private final ExecutionRepository executionRepository;
    private final ObjectMapper kayentaObjectMapper;
    private final ConfigurableApplicationContext context;
    private final OrcaCompositeHealthContributor orcaCompositeHealthContributor;
    private final ScheduledAnnotationBeanPostProcessor postProcessor;
    private Boolean upAtLeastOnce = false;

    @Autowired
    public PipelineController(ExecutionLauncher executionLauncher, ExecutionRepository executionRepository, ObjectMapper kayentaObjectMapper, ConfigurableApplicationContext context, HealthContributorRegistry healthContributorRegistry, StatusAggregator statusAggregator, ScheduledAnnotationBeanPostProcessor postProcessor) {
        this.executionLauncher = executionLauncher;
        this.executionRepository = executionRepository;
        this.kayentaObjectMapper = kayentaObjectMapper;
        this.context = context;
        this.orcaCompositeHealthContributor = new OrcaCompositeHealthContributor(statusAggregator, healthContributorRegistry);
        this.postProcessor = postProcessor;
    }

    @Scheduled(initialDelay=10000L, fixedDelay=5000L)
    void startOrcaQueueProcessing() {
        if (!this.upAtLeastOnce.booleanValue()) {
            Status status = this.orcaCompositeHealthContributor.status();
            if (status == Status.UP) {
                this.upAtLeastOnce = true;
                this.context.publishEvent((ApplicationEvent)new RemoteStatusChangedEvent(new DiscoveryStatusChangeEvent(InstanceStatus.STARTING, InstanceStatus.UP)));
                this.postProcessor.postProcessBeforeDestruction((Object)this, null);
                log.info("Health indicators are all reporting UP; starting orca queue processing");
            } else {
                log.warn("Health indicators are still reporting DOWN; not starting orca queue processing yet: {}", (Object)status);
            }
        }
    }

    @Operation(summary="Initiate a pipeline execution")
    @RequestMapping(value={"/start"}, method={RequestMethod.POST})
    String start(@RequestBody Map map) throws Exception {
        return this.startPipeline(map);
    }

    @Operation(summary="Retrieve a pipeline execution")
    @RequestMapping(value={"/{executionId}"}, method={RequestMethod.GET})
    PipelineExecution getPipeline(@PathVariable String executionId) {
        return this.executionRepository.retrieve(ExecutionType.PIPELINE, executionId);
    }

    @Operation(summary="Cancel a pipeline execution")
    @RequestMapping(value={"/{executionId}/cancel"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    void cancel(@PathVariable String executionId) {
        log.info("Cancelling pipeline execution {}...", (Object)executionId);
        PipelineExecution pipeline = this.executionRepository.retrieve(ExecutionType.PIPELINE, executionId);
        if (pipeline.getStatus().isComplete()) {
            log.debug("Not changing status of pipeline execution {} to CANCELED since execution is already completed: {}", (Object)executionId, (Object)pipeline.getStatus());
            return;
        }
        this.executionRepository.cancel(ExecutionType.PIPELINE, executionId);
        this.executionRepository.updateStatus(ExecutionType.PIPELINE, executionId, ExecutionStatus.CANCELED);
    }

    @Operation(summary="Delete a pipeline execution")
    @RequestMapping(value={"/{executionId}"}, method={RequestMethod.DELETE})
    ResponseEntity delete(@PathVariable String executionId) {
        log.info("Deleting pipeline execution {}...", (Object)executionId);
        PipelineExecution pipeline = this.executionRepository.retrieve(ExecutionType.PIPELINE, executionId);
        if (!pipeline.getStatus().isComplete()) {
            log.info("Not deleting incomplete pipeline with id {}", (Object)executionId);
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        this.executionRepository.delete(ExecutionType.PIPELINE, executionId);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Operation(summary="List all pipeline IDs")
    @RequestMapping(method={RequestMethod.GET})
    List<String> list() {
        return this.executionRepository.retrieveAllExecutionIds(ExecutionType.PIPELINE);
    }

    private String startPipeline(Map config) throws Exception {
        String json = this.kayentaObjectMapper.writeValueAsString((Object)config);
        log.info("Requested pipeline: {}", (Object)json);
        PipelineExecution pipeline = this.executionLauncher.start(ExecutionType.PIPELINE, config);
        return pipeline.getId();
    }

    private static class FeatureNotEnabledException
    extends RuntimeException {
        public FeatureNotEnabledException(String message) {
            super(message);
        }
    }
}

