/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.orca.controllers;

import com.netflix.spinnaker.kork.discovery.DiscoveryStatusChangeEvent;
import com.netflix.spinnaker.kork.discovery.InstanceStatus;
import com.netflix.spinnaker.kork.discovery.RemoteStatusChangedEvent;
import com.netflix.spinnaker.kork.web.exceptions.ValidationException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/orca"})
public class AdminController {
    private final ApplicationEventPublisher publisher;

    @Autowired
    public AdminController(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @RequestMapping(value={"/instance/enabled"}, consumes={"application/json"}, method={RequestMethod.POST})
    void setInstanceEnabled(@RequestBody Map<String, Boolean> enabledWrapper) {
        Boolean enabled = enabledWrapper.get("enabled");
        if (enabled == null) {
            throw new ValidationException("The field 'enabled' must be set.", null);
        }
        this.setInstanceEnabled(enabled);
    }

    private void setInstanceEnabled(boolean enabled) {
        InstanceStatus currentStatus = enabled ? InstanceStatus.UP : InstanceStatus.OUT_OF_SERVICE;
        InstanceStatus previousStatus = currentStatus == InstanceStatus.OUT_OF_SERVICE ? InstanceStatus.UP : InstanceStatus.UNKNOWN;
        this.publisher.publishEvent((ApplicationEvent)new RemoteStatusChangedEvent(new DiscoveryStatusChangeEvent(previousStatus, currentStatus)));
    }
}

