/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.health;

import com.netflix.kayenta.prometheus.health.PrometheusHealthCache;
import com.netflix.kayenta.prometheus.health.PrometheusHealthJob;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class PrometheusHealthIndicator
extends AbstractHealthIndicator {
    private final PrometheusHealthCache healthCache;

    public PrometheusHealthIndicator(PrometheusHealthCache healthCache) {
        this.healthCache = healthCache;
    }

    protected void doHealthCheck(Health.Builder builder) {
        List<PrometheusHealthJob.PrometheusHealthStatus> healthStatuses = this.healthCache.getHealthStatuses();
        if (healthStatuses.isEmpty()) {
            builder.status(Status.DOWN).withDetail("reason", (Object)"Health status is not yet ready.");
            return;
        }
        boolean anyIsDown = healthStatuses.stream().anyMatch(status -> status.getStatus().equals((Object)Status.DOWN));
        if (anyIsDown) {
            builder.status(Status.DOWN).withDetail("reason", (Object)"One of the Prometheus remote services is DOWN.");
        } else {
            builder.status(Status.UP);
        }
        healthStatuses.forEach(healthStatus -> {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("status", healthStatus.getStatus().getCode());
            if (healthStatus.getErrorDetails() != null) {
                details.put("error", healthStatus.getErrorDetails());
            }
            builder.withDetail(healthStatus.getAccountName(), details);
        });
    }
}

