/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.kayenta.prometheus.security.PrometheusCredentials;
import com.netflix.kayenta.prometheus.service.PrometheusRemoteService;
import com.netflix.kayenta.retrofit.config.RemoteService;
import com.netflix.kayenta.security.AccountCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;

public class PrometheusNamedAccountCredentials
implements AccountCredentials<PrometheusCredentials> {
    @NotNull
    private String name;
    @NotNull
    private List<AccountCredentials.Type> supportedTypes;
    @NotNull
    private PrometheusCredentials credentials;
    @NotNull
    private RemoteService endpoint;
    @JsonIgnore
    PrometheusRemoteService prometheusRemoteService;

    public String getType() {
        return "prometheus";
    }

    PrometheusNamedAccountCredentials(String name, List<AccountCredentials.Type> supportedTypes, PrometheusCredentials credentials, RemoteService endpoint, PrometheusRemoteService prometheusRemoteService) {
        this.name = name;
        this.supportedTypes = supportedTypes;
        this.credentials = credentials;
        this.endpoint = endpoint;
        this.prometheusRemoteService = prometheusRemoteService;
    }

    public static PrometheusNamedAccountCredentialsBuilder builder() {
        return new PrometheusNamedAccountCredentialsBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<AccountCredentials.Type> getSupportedTypes() {
        return this.supportedTypes;
    }

    public PrometheusCredentials getCredentials() {
        return this.credentials;
    }

    public RemoteService getEndpoint() {
        return this.endpoint;
    }

    public PrometheusRemoteService getPrometheusRemoteService() {
        return this.prometheusRemoteService;
    }

    public PrometheusNamedAccountCredentials setName(String name) {
        this.name = name;
        return this;
    }

    public PrometheusNamedAccountCredentials setSupportedTypes(List<AccountCredentials.Type> supportedTypes) {
        this.supportedTypes = supportedTypes;
        return this;
    }

    public PrometheusNamedAccountCredentials setCredentials(PrometheusCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public PrometheusNamedAccountCredentials setEndpoint(RemoteService endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public PrometheusNamedAccountCredentials setPrometheusRemoteService(PrometheusRemoteService prometheusRemoteService) {
        this.prometheusRemoteService = prometheusRemoteService;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrometheusNamedAccountCredentials)) {
            return false;
        }
        PrometheusNamedAccountCredentials other = (PrometheusNamedAccountCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<AccountCredentials.Type> this$supportedTypes = this.getSupportedTypes();
        List<AccountCredentials.Type> other$supportedTypes = other.getSupportedTypes();
        if (this$supportedTypes == null ? other$supportedTypes != null : !((Object)this$supportedTypes).equals(other$supportedTypes)) {
            return false;
        }
        PrometheusCredentials this$credentials = this.getCredentials();
        PrometheusCredentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        RemoteService this$endpoint = this.getEndpoint();
        RemoteService other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        PrometheusRemoteService this$prometheusRemoteService = this.getPrometheusRemoteService();
        PrometheusRemoteService other$prometheusRemoteService = other.getPrometheusRemoteService();
        return !(this$prometheusRemoteService == null ? other$prometheusRemoteService != null : !this$prometheusRemoteService.equals(other$prometheusRemoteService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrometheusNamedAccountCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<AccountCredentials.Type> $supportedTypes = this.getSupportedTypes();
        result = result * 59 + ($supportedTypes == null ? 43 : ((Object)$supportedTypes).hashCode());
        PrometheusCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        RemoteService $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        PrometheusRemoteService $prometheusRemoteService = this.getPrometheusRemoteService();
        result = result * 59 + ($prometheusRemoteService == null ? 43 : $prometheusRemoteService.hashCode());
        return result;
    }

    public String toString() {
        return "PrometheusNamedAccountCredentials(name=" + this.getName() + ", supportedTypes=" + this.getSupportedTypes() + ", credentials=" + this.getCredentials() + ", endpoint=" + this.getEndpoint() + ", prometheusRemoteService=" + this.getPrometheusRemoteService() + ")";
    }

    public static class PrometheusNamedAccountCredentialsBuilder {
        private String name;
        private ArrayList<AccountCredentials.Type> supportedTypes;
        private PrometheusCredentials credentials;
        private RemoteService endpoint;
        private PrometheusRemoteService prometheusRemoteService;

        PrometheusNamedAccountCredentialsBuilder() {
        }

        public PrometheusNamedAccountCredentialsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PrometheusNamedAccountCredentialsBuilder supportedType(AccountCredentials.Type supportedType) {
            if (this.supportedTypes == null) {
                this.supportedTypes = new ArrayList();
            }
            this.supportedTypes.add(supportedType);
            return this;
        }

        public PrometheusNamedAccountCredentialsBuilder supportedTypes(Collection<? extends AccountCredentials.Type> supportedTypes) {
            if (supportedTypes == null) {
                throw new IllegalArgumentException("supportedTypes cannot be null");
            }
            if (this.supportedTypes == null) {
                this.supportedTypes = new ArrayList();
            }
            this.supportedTypes.addAll(supportedTypes);
            return this;
        }

        public PrometheusNamedAccountCredentialsBuilder clearSupportedTypes() {
            if (this.supportedTypes != null) {
                this.supportedTypes.clear();
            }
            return this;
        }

        public PrometheusNamedAccountCredentialsBuilder credentials(PrometheusCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public PrometheusNamedAccountCredentialsBuilder endpoint(RemoteService endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public PrometheusNamedAccountCredentialsBuilder prometheusRemoteService(PrometheusRemoteService prometheusRemoteService) {
            this.prometheusRemoteService = prometheusRemoteService;
            return this;
        }

        public PrometheusNamedAccountCredentials build() {
            List<AccountCredentials.Type> supportedTypes;
            switch (this.supportedTypes == null ? 0 : this.supportedTypes.size()) {
                case 0: {
                    supportedTypes = Collections.emptyList();
                    break;
                }
                case 1: {
                    supportedTypes = Collections.singletonList(this.supportedTypes.get(0));
                    break;
                }
                default: {
                    supportedTypes = Collections.unmodifiableList(new ArrayList<AccountCredentials.Type>(this.supportedTypes));
                }
            }
            return new PrometheusNamedAccountCredentials(this.name, supportedTypes, this.credentials, this.endpoint, this.prometheusRemoteService);
        }

        public String toString() {
            return "PrometheusNamedAccountCredentials.PrometheusNamedAccountCredentialsBuilder(name=" + this.name + ", supportedTypes=" + this.supportedTypes + ", credentials=" + this.credentials + ", endpoint=" + this.endpoint + ", prometheusRemoteService=" + this.prometheusRemoteService + ")";
        }
    }
}

