/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.metrics;

import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.canary.CanaryMetricConfig;
import com.netflix.kayenta.canary.CanaryMetricSetQueryConfig;
import com.netflix.kayenta.canary.CanaryScope;
import com.netflix.kayenta.canary.providers.metrics.PrometheusCanaryMetricSetQueryConfig;
import com.netflix.kayenta.canary.providers.metrics.QueryConfigUtils;
import com.netflix.kayenta.metrics.MetricSet;
import com.netflix.kayenta.metrics.MetricsService;
import com.netflix.kayenta.prometheus.canary.PrometheusCanaryScope;
import com.netflix.kayenta.prometheus.metrics.PrometheusMetricDescriptorsCache;
import com.netflix.kayenta.prometheus.model.PrometheusResults;
import com.netflix.kayenta.prometheus.security.PrometheusNamedAccountCredentials;
import com.netflix.kayenta.prometheus.service.PrometheusRemoteService;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PrometheusMetricsService
implements MetricsService {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsService.class);
    @NotNull
    private String scopeLabel;
    @NotNull
    private List<String> accountNames;
    @Autowired
    private final AccountCredentialsRepository accountCredentialsRepository;
    @Autowired
    private final Registry registry;
    @Autowired
    private final PrometheusMetricDescriptorsCache metricDescriptorsCache;

    public String getType() {
        return "prometheus";
    }

    public boolean servicesAccount(String accountName) {
        return this.accountNames.contains(accountName);
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringBuilder addScopeFilter(StringBuilder queryBuilder, PrometheusCanaryScope prometheusCanaryScope, String resourceType, PrometheusCanaryMetricSetQueryConfig queryConfig, String customFilter) {
        List<String> filters;
        block8: {
            block9: {
                String scope = prometheusCanaryScope.getScope();
                String projectId = prometheusCanaryScope.getProject();
                String location = prometheusCanaryScope.getLocation();
                filters = queryConfig.getLabelBindings();
                if (filters == null) {
                    filters = new ArrayList<String>();
                }
                if (!StringUtils.isEmpty((Object)customFilter)) break block9;
                if ("gce_instance".equals(resourceType)) {
                    PrometheusMetricsService.addGCEFilters(this.scopeLabel, scope, projectId, location, filters);
                    break block8;
                } else if ("aws_ec2_instance".equals(resourceType)) {
                    PrometheusMetricsService.addEC2Filters("asg_groupName", scope, location, filters);
                    break block8;
                } else {
                    if (!StringUtils.isEmpty((Object)resourceType)) {
                        throw new IllegalArgumentException("There is no explicit support for resourceType '" + resourceType + "'. You may build whatever query makes sense for your environment via label bindings and custom filter templates.");
                    }
                    throw new IllegalArgumentException("Either a resource type or a custom filter is required.");
                }
            }
            List<String> customFilterTokens = Arrays.asList(customFilter.split(","));
            filters = new ArrayList<String>(filters);
            filters.addAll(0, customFilterTokens);
        }
        if (!filters.isEmpty()) {
            String sep = "";
            queryBuilder.append('{');
            for (String binding : filters) {
                queryBuilder.append(sep);
                queryBuilder.append(binding);
                sep = ",";
            }
            queryBuilder.append('}');
        }
        return queryBuilder;
    }

    private static void addGCEFilters(String scopeLabel, String scope, String projectId, String location, List<String> filters) {
        if (StringUtils.isEmpty((Object)location)) {
            throw new IllegalArgumentException("Location (i.e. region) is required when resourceType is 'gce_instance'.");
        }
        if (!StringUtils.isEmpty((Object)scope)) {
            scope = (String)scope + "-.{4}";
            filters.add(scopeLabel + "=~\"" + (String)scope + "\"");
        }
        Object zoneRegex = ".+/";
        if (!StringUtils.isEmpty((Object)projectId)) {
            zoneRegex = (String)zoneRegex + "projects/" + projectId + "/";
        }
        zoneRegex = (String)zoneRegex + "zones/" + location + "-.{1}";
        filters.add("zone=~\"" + (String)zoneRegex + "\"");
    }

    private static void addEC2Filters(String scopeLabel, String scope, String location, List<String> filters) {
        if (StringUtils.isEmpty((Object)location)) {
            throw new IllegalArgumentException("Location (i.e. region) is required when resourceType is 'aws_ec2_instance'.");
        }
        if (!StringUtils.isEmpty((Object)scope)) {
            filters.add(scopeLabel + "=\"" + scope + "\"");
        }
        filters.add("zone=~\"" + location + ".{1}\"");
    }

    private static StringBuilder addAvgQuery(StringBuilder queryBuilder) {
        return queryBuilder.insert(0, "avg(").append(")");
    }

    private static StringBuilder addGroupByQuery(StringBuilder queryBuilder, PrometheusCanaryMetricSetQueryConfig queryConfig) {
        List<String> groupByFields = queryConfig.getGroupByFields();
        if (!CollectionUtils.isEmpty(groupByFields)) {
            queryBuilder.append(" by (");
            String sep = "";
            for (String elem : groupByFields) {
                queryBuilder.append(sep);
                queryBuilder.append(elem);
                sep = ",";
            }
            queryBuilder.append(")");
        }
        return queryBuilder;
    }

    public String buildQuery(String metricsAccountName, CanaryConfig canaryConfig, CanaryMetricConfig canaryMetricConfig, CanaryScope canaryScope) {
        PrometheusCanaryMetricSetQueryConfig queryConfig = (PrometheusCanaryMetricSetQueryConfig)canaryMetricConfig.getQuery();
        PrometheusCanaryScope prometheusCanaryScope = (PrometheusCanaryScope)canaryScope;
        String resourceType = StringUtils.hasText((String)queryConfig.getResourceType()) ? queryConfig.getResourceType() : prometheusCanaryScope.getResourceType();
        String customFilter = QueryConfigUtils.expandCustomFilter((CanaryConfig)canaryConfig, (CanaryMetricSetQueryConfig)queryConfig, (CanaryScope)prometheusCanaryScope, (String[])new String[]{"project", "resourceType", "scope", "location"});
        if (!StringUtils.isEmpty((Object)customFilter) && customFilter.startsWith("PromQL:")) {
            String promQlExpr = customFilter.substring(7);
            log.debug("Detected complete PromQL expression: {}", (Object)promQlExpr);
            return promQlExpr;
        }
        if (StringUtils.isEmpty((Object)queryConfig.getMetricName())) {
            throw new IllegalArgumentException("Metric Name is required when query type is Default.");
        }
        StringBuilder queryBuilder = new StringBuilder(queryConfig.getMetricName());
        queryBuilder = this.addScopeFilter(queryBuilder, prometheusCanaryScope, resourceType, queryConfig, customFilter);
        queryBuilder = PrometheusMetricsService.addAvgQuery(queryBuilder);
        queryBuilder = PrometheusMetricsService.addGroupByQuery(queryBuilder, queryConfig);
        log.debug("query={}", (Object)queryBuilder);
        return queryBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetricSet> queryMetrics(String accountName, CanaryConfig canaryConfig, CanaryMetricConfig canaryMetricConfig, CanaryScope canaryScope) throws IOException {
        List<PrometheusResults> prometheusResultsList;
        if (!(canaryScope instanceof PrometheusCanaryScope)) {
            throw new IllegalArgumentException("Canary scope not instance of PrometheusCanaryScope: " + canaryScope + ". One common cause is having multiple METRICS_STORE accounts configured but neglecting to explicitly specify which account to use for a given request.");
        }
        PrometheusNamedAccountCredentials credentials = (PrometheusNamedAccountCredentials)this.accountCredentialsRepository.getRequiredOne(accountName);
        PrometheusRemoteService prometheusRemoteService = credentials.getPrometheusRemoteService();
        if (StringUtils.isEmpty((Object)canaryScope.getStart())) {
            throw new IllegalArgumentException("Start time is required.");
        }
        if (StringUtils.isEmpty((Object)canaryScope.getEnd())) {
            throw new IllegalArgumentException("End time is required.");
        }
        String query = this.buildQuery(accountName, canaryConfig, canaryMetricConfig, canaryScope).toString();
        long startTime = this.registry.clock().monotonicTime();
        try {
            prometheusResultsList = prometheusRemoteService.rangeQuery(query, canaryScope.getStart().toString(), canaryScope.getEnd().toString(), canaryScope.getStep());
        }
        finally {
            long endTime = this.registry.clock().monotonicTime();
            Id prometheusFetchTimerId = this.registry.createId("prometheus.fetchTime");
            this.registry.timer(prometheusFetchTimerId).record(endTime - startTime, TimeUnit.NANOSECONDS);
        }
        ArrayList<MetricSet> metricSetList = new ArrayList<MetricSet>();
        if (!CollectionUtils.isEmpty(prometheusResultsList)) {
            for (PrometheusResults prometheusResults : prometheusResultsList) {
                Instant responseStartTimeInstant = Instant.ofEpochMilli(prometheusResults.getStartTimeMillis());
                Instant responseEndTimeInstant = Instant.ofEpochMilli(prometheusResults.getEndTimeMillis());
                MetricSet.MetricSetBuilder metricSetBuilder = MetricSet.builder().name(canaryMetricConfig.getName()).startTimeMillis(prometheusResults.getStartTimeMillis()).startTimeIso(responseStartTimeInstant.toString()).endTimeMillis(prometheusResults.getEndTimeMillis()).endTimeIso(responseEndTimeInstant.toString()).stepMillis(TimeUnit.SECONDS.toMillis(prometheusResults.getStepSecs())).values(prometheusResults.getValues());
                Map<String, String> tags = prometheusResults.getTags();
                if (tags != null) {
                    metricSetBuilder.tags(tags);
                }
                metricSetBuilder.attribute("query", query);
                metricSetList.add(metricSetBuilder.build());
            }
        } else {
            log.warn("Received no data from Prometheus for query: {} scope: {}", (Object)query, (Object)canaryScope);
            MetricSet.MetricSetBuilder metricSetBuilder = MetricSet.builder().name(canaryMetricConfig.getName()).startTimeMillis(canaryScope.getStart().toEpochMilli()).startTimeIso(canaryScope.getStart().toString()).endTimeMillis(canaryScope.getEnd().toEpochMilli()).endTimeIso(canaryScope.getEnd().toString()).stepMillis(TimeUnit.SECONDS.toMillis(canaryScope.getStep())).values(Collections.emptyList());
            metricSetBuilder.attribute("query", query);
            metricSetList.add(metricSetBuilder.build());
        }
        return metricSetList;
    }

    public List<Map> getMetadata(String metricsAccountName, String filter) {
        return this.metricDescriptorsCache.getMetadata(metricsAccountName, filter);
    }

    PrometheusMetricsService(String scopeLabel, List<String> accountNames, AccountCredentialsRepository accountCredentialsRepository, Registry registry, PrometheusMetricDescriptorsCache metricDescriptorsCache) {
        this.scopeLabel = scopeLabel;
        this.accountNames = accountNames;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.registry = registry;
        this.metricDescriptorsCache = metricDescriptorsCache;
    }

    public static PrometheusMetricsServiceBuilder builder() {
        return new PrometheusMetricsServiceBuilder();
    }

    public List<String> getAccountNames() {
        return this.accountNames;
    }

    public static class PrometheusMetricsServiceBuilder {
        private String scopeLabel;
        private ArrayList<String> accountNames;
        private AccountCredentialsRepository accountCredentialsRepository;
        private Registry registry;
        private PrometheusMetricDescriptorsCache metricDescriptorsCache;

        PrometheusMetricsServiceBuilder() {
        }

        public PrometheusMetricsServiceBuilder scopeLabel(String scopeLabel) {
            this.scopeLabel = scopeLabel;
            return this;
        }

        public PrometheusMetricsServiceBuilder accountName(String accountName) {
            if (this.accountNames == null) {
                this.accountNames = new ArrayList();
            }
            this.accountNames.add(accountName);
            return this;
        }

        public PrometheusMetricsServiceBuilder accountNames(Collection<? extends String> accountNames) {
            if (accountNames == null) {
                throw new IllegalArgumentException("accountNames cannot be null");
            }
            if (this.accountNames == null) {
                this.accountNames = new ArrayList();
            }
            this.accountNames.addAll(accountNames);
            return this;
        }

        public PrometheusMetricsServiceBuilder clearAccountNames() {
            if (this.accountNames != null) {
                this.accountNames.clear();
            }
            return this;
        }

        public PrometheusMetricsServiceBuilder accountCredentialsRepository(AccountCredentialsRepository accountCredentialsRepository) {
            this.accountCredentialsRepository = accountCredentialsRepository;
            return this;
        }

        public PrometheusMetricsServiceBuilder registry(Registry registry) {
            this.registry = registry;
            return this;
        }

        public PrometheusMetricsServiceBuilder metricDescriptorsCache(PrometheusMetricDescriptorsCache metricDescriptorsCache) {
            this.metricDescriptorsCache = metricDescriptorsCache;
            return this;
        }

        public PrometheusMetricsService build() {
            List<String> accountNames;
            switch (this.accountNames == null ? 0 : this.accountNames.size()) {
                case 0: {
                    accountNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    accountNames = Collections.singletonList(this.accountNames.get(0));
                    break;
                }
                default: {
                    accountNames = Collections.unmodifiableList(new ArrayList<String>(this.accountNames));
                }
            }
            return new PrometheusMetricsService(this.scopeLabel, accountNames, this.accountCredentialsRepository, this.registry, this.metricDescriptorsCache);
        }

        public String toString() {
            return "PrometheusMetricsService.PrometheusMetricsServiceBuilder(scopeLabel=" + this.scopeLabel + ", accountNames=" + this.accountNames + ", accountCredentialsRepository=" + this.accountCredentialsRepository + ", registry=" + this.registry + ", metricDescriptorsCache=" + this.metricDescriptorsCache + ")";
        }
    }
}

