/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.orca;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.canary.CanaryScope;
import com.netflix.kayenta.metrics.SynchronousQueryProcessor;
import com.netflix.kayenta.prometheus.canary.PrometheusCanaryScope;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrometheusFetchTask
implements RetryableTask {
    private static final Logger log = LoggerFactory.getLogger(PrometheusFetchTask.class);
    private final ObjectMapper kayentaObjectMapper;
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final SynchronousQueryProcessor synchronousQueryProcessor;

    @Autowired
    public PrometheusFetchTask(ObjectMapper kayentaObjectMapper, AccountCredentialsRepository accountCredentialsRepository, SynchronousQueryProcessor synchronousQueryProcessor) {
        this.kayentaObjectMapper = kayentaObjectMapper;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.synchronousQueryProcessor = synchronousQueryProcessor;
    }

    public long getBackoffPeriod() {
        return Duration.ofSeconds(2L).toMillis();
    }

    public long getTimeout() {
        return Duration.ofMinutes(2L).toMillis();
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        CanaryScope canaryScope;
        Map context = stage.getContext();
        String metricsAccountName = (String)context.get("metricsAccountName");
        String storageAccountName = (String)context.get("storageAccountName");
        Map canaryConfigMap = (Map)context.get("canaryConfig");
        CanaryConfig canaryConfig = (CanaryConfig)this.kayentaObjectMapper.convertValue((Object)canaryConfigMap, CanaryConfig.class);
        int metricIndex = (Integer)stage.getContext().get("metricIndex");
        try {
            canaryScope = (CanaryScope)this.kayentaObjectMapper.readValue((String)stage.getContext().get("canaryScope"), PrometheusCanaryScope.class);
        }
        catch (IOException e) {
            log.warn("Unable to parse JSON scope", (Throwable)e);
            throw new RuntimeException(e);
        }
        String resolvedMetricsAccountName = this.accountCredentialsRepository.getRequiredOneBy(metricsAccountName, AccountCredentials.Type.METRICS_STORE).getName();
        String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
        return this.synchronousQueryProcessor.executeQueryAndProduceTaskResult(resolvedMetricsAccountName, resolvedStorageAccountName, canaryConfig, metricIndex, canaryScope);
    }
}

