/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.security;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusCredentials {
    private static final Logger log = LoggerFactory.getLogger(PrometheusCredentials.class);
    private static String applicationVersion = Optional.ofNullable(PrometheusCredentials.class.getPackage().getImplementationVersion()).orElse("Unknown");
    private String username;
    private String password;
    private String usernamePasswordFile;
    private String bearerToken;

    PrometheusCredentials(String username, String password, String usernamePasswordFile, String bearerToken) {
        this.username = username;
        this.password = password;
        this.usernamePasswordFile = usernamePasswordFile;
        this.bearerToken = bearerToken;
    }

    public static PrometheusCredentialsBuilder builder() {
        return new PrometheusCredentialsBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsernamePasswordFile() {
        return this.usernamePasswordFile;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public PrometheusCredentials setUsername(String username) {
        this.username = username;
        return this;
    }

    public PrometheusCredentials setPassword(String password) {
        this.password = password;
        return this;
    }

    public PrometheusCredentials setUsernamePasswordFile(String usernamePasswordFile) {
        this.usernamePasswordFile = usernamePasswordFile;
        return this;
    }

    public PrometheusCredentials setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrometheusCredentials)) {
            return false;
        }
        PrometheusCredentials other = (PrometheusCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$usernamePasswordFile = this.getUsernamePasswordFile();
        String other$usernamePasswordFile = other.getUsernamePasswordFile();
        if (this$usernamePasswordFile == null ? other$usernamePasswordFile != null : !this$usernamePasswordFile.equals(other$usernamePasswordFile)) {
            return false;
        }
        String this$bearerToken = this.getBearerToken();
        String other$bearerToken = other.getBearerToken();
        return !(this$bearerToken == null ? other$bearerToken != null : !this$bearerToken.equals(other$bearerToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrometheusCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $usernamePasswordFile = this.getUsernamePasswordFile();
        result = result * 59 + ($usernamePasswordFile == null ? 43 : $usernamePasswordFile.hashCode());
        String $bearerToken = this.getBearerToken();
        result = result * 59 + ($bearerToken == null ? 43 : $bearerToken.hashCode());
        return result;
    }

    public String toString() {
        return "PrometheusCredentials(username=" + this.getUsername() + ", password=" + this.getPassword() + ", usernamePasswordFile=" + this.getUsernamePasswordFile() + ", bearerToken=" + this.getBearerToken() + ")";
    }

    public static class PrometheusCredentialsBuilder {
        private String username;
        private String password;
        private String usernamePasswordFile;
        private String bearerToken;

        PrometheusCredentialsBuilder() {
        }

        public PrometheusCredentialsBuilder username(String username) {
            this.username = username;
            return this;
        }

        public PrometheusCredentialsBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PrometheusCredentialsBuilder usernamePasswordFile(String usernamePasswordFile) {
            this.usernamePasswordFile = usernamePasswordFile;
            return this;
        }

        public PrometheusCredentialsBuilder bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public PrometheusCredentials build() {
            return new PrometheusCredentials(this.username, this.password, this.usernamePasswordFile, this.bearerToken);
        }

        public String toString() {
            return "PrometheusCredentials.PrometheusCredentialsBuilder(username=" + this.username + ", password=" + this.password + ", usernamePasswordFile=" + this.usernamePasswordFile + ", bearerToken=" + this.bearerToken + ")";
        }
    }
}

