/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.canary;

import com.netflix.kayenta.canary.CanaryScope;
import com.netflix.kayenta.canary.CanaryScopeFactory;
import com.netflix.kayenta.prometheus.canary.PrometheusCanaryScope;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class PrometheusCanaryScopeFactory
implements CanaryScopeFactory {
    public boolean handles(String serviceType) {
        return "prometheus".equals(serviceType);
    }

    public CanaryScope buildCanaryScope(CanaryScope canaryScope) {
        PrometheusCanaryScope prometheusCanaryScope = new PrometheusCanaryScope();
        prometheusCanaryScope.setScope(canaryScope.getScope());
        prometheusCanaryScope.setLocation(canaryScope.getLocation());
        prometheusCanaryScope.setStart(canaryScope.getStart());
        prometheusCanaryScope.setEnd(canaryScope.getEnd());
        prometheusCanaryScope.setStep(canaryScope.getStep());
        prometheusCanaryScope.setExtendedScopeParams(canaryScope.getExtendedScopeParams());
        Map extendedScopeParams = prometheusCanaryScope.getExtendedScopeParams();
        if (extendedScopeParams != null) {
            if (extendedScopeParams.containsKey("project")) {
                prometheusCanaryScope.setProject((String)extendedScopeParams.get("project"));
            }
            if (extendedScopeParams.containsKey("resourceType")) {
                prometheusCanaryScope.setResourceType((String)extendedScopeParams.get("resourceType"));
            }
        }
        return prometheusCanaryScope;
    }
}

