/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.kayenta.prometheus.service.PrometheusRemoteService;
import com.netflix.kayenta.retrofit.config.RemoteService;
import com.netflix.kayenta.security.AccountCredentials;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;

public class PrometheusManagedAccount
extends AccountCredentials<PrometheusManagedAccount> {
    @NotNull
    private RemoteService endpoint;
    private String username;
    @JsonIgnore
    private String password;
    private String usernamePasswordFile;
    @JsonIgnore
    private String bearerToken;
    @JsonIgnore
    transient PrometheusRemoteService prometheusRemoteService;

    public List<AccountCredentials.Type> getSupportedTypes() {
        return Collections.singletonList(AccountCredentials.Type.METRICS_STORE);
    }

    public String getType() {
        return "prometheus";
    }

    public PrometheusManagedAccount getCredentials() {
        return this;
    }

    protected PrometheusManagedAccount(PrometheusManagedAccountBuilder<?, ?> b) {
        super(b);
        this.endpoint = b.endpoint;
        this.username = b.username;
        this.password = b.password;
        this.usernamePasswordFile = b.usernamePasswordFile;
        this.bearerToken = b.bearerToken;
        this.prometheusRemoteService = b.prometheusRemoteService;
    }

    public static PrometheusManagedAccountBuilder<?, ?> builder() {
        return new PrometheusManagedAccountBuilderImpl();
    }

    public RemoteService getEndpoint() {
        return this.endpoint;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsernamePasswordFile() {
        return this.usernamePasswordFile;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public PrometheusRemoteService getPrometheusRemoteService() {
        return this.prometheusRemoteService;
    }

    public PrometheusManagedAccount setEndpoint(RemoteService endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public PrometheusManagedAccount setUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonIgnore
    public PrometheusManagedAccount setPassword(String password) {
        this.password = password;
        return this;
    }

    public PrometheusManagedAccount setUsernamePasswordFile(String usernamePasswordFile) {
        this.usernamePasswordFile = usernamePasswordFile;
        return this;
    }

    @JsonIgnore
    public PrometheusManagedAccount setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return this;
    }

    @JsonIgnore
    public PrometheusManagedAccount setPrometheusRemoteService(PrometheusRemoteService prometheusRemoteService) {
        this.prometheusRemoteService = prometheusRemoteService;
        return this;
    }

    public PrometheusManagedAccount() {
    }

    private static final class PrometheusManagedAccountBuilderImpl
    extends PrometheusManagedAccountBuilder<PrometheusManagedAccount, PrometheusManagedAccountBuilderImpl> {
        private PrometheusManagedAccountBuilderImpl() {
        }

        @Override
        protected PrometheusManagedAccountBuilderImpl self() {
            return this;
        }

        @Override
        public PrometheusManagedAccount build() {
            return new PrometheusManagedAccount(this);
        }
    }

    public static abstract class PrometheusManagedAccountBuilder<C extends PrometheusManagedAccount, B extends PrometheusManagedAccountBuilder<C, B>>
    extends AccountCredentials.AccountCredentialsBuilder<PrometheusManagedAccount, C, B> {
        private RemoteService endpoint;
        private String username;
        private String password;
        private String usernamePasswordFile;
        private String bearerToken;
        private PrometheusRemoteService prometheusRemoteService;

        public B endpoint(RemoteService endpoint) {
            this.endpoint = endpoint;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @JsonIgnore
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B usernamePasswordFile(String usernamePasswordFile) {
            this.usernamePasswordFile = usernamePasswordFile;
            return (B)this.self();
        }

        @JsonIgnore
        public B bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return (B)this.self();
        }

        @JsonIgnore
        public B prometheusRemoteService(PrometheusRemoteService prometheusRemoteService) {
            this.prometheusRemoteService = prometheusRemoteService;
            return (B)this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "PrometheusManagedAccount.PrometheusManagedAccountBuilder(super=" + super.toString() + ", endpoint=" + this.endpoint + ", username=" + this.username + ", password=" + this.password + ", usernamePasswordFile=" + this.usernamePasswordFile + ", bearerToken=" + this.bearerToken + ", prometheusRemoteService=" + this.prometheusRemoteService + ")";
        }
    }
}

