/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.config;

import com.netflix.kayenta.metrics.MetricsService;
import com.netflix.kayenta.prometheus.config.PrometheusConfigurationProperties;
import com.netflix.kayenta.prometheus.config.PrometheusConfigurationTestControllerDefaultProperties;
import com.netflix.kayenta.prometheus.config.PrometheusManagedAccount;
import com.netflix.kayenta.prometheus.config.PrometheusResponseConverter;
import com.netflix.kayenta.prometheus.health.PrometheusHealthCache;
import com.netflix.kayenta.prometheus.health.PrometheusHealthIndicator;
import com.netflix.kayenta.prometheus.health.PrometheusHealthJob;
import com.netflix.kayenta.prometheus.metrics.PrometheusMetricDescriptorsCache;
import com.netflix.kayenta.prometheus.metrics.PrometheusMetricsService;
import com.netflix.kayenta.prometheus.service.PrometheusRemoteService;
import com.netflix.kayenta.retrofit.config.RetrofitClientFactory;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.CollectionUtils;
import retrofit.converter.Converter;

@Configuration
@ConditionalOnProperty(value={"kayenta.prometheus.enabled"})
@ComponentScan(value={"com.netflix.kayenta.prometheus"})
public class PrometheusConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PrometheusConfiguration.class);

    @Bean
    @ConfigurationProperties(value="kayenta.prometheus")
    PrometheusConfigurationProperties prometheusConfigurationProperties() {
        return new PrometheusConfigurationProperties();
    }

    @Bean
    @ConfigurationProperties(value="kayenta.prometheus.test-controller-defaults")
    PrometheusConfigurationTestControllerDefaultProperties prometheusConfigurationTestControllerDefaultProperties() {
        return new PrometheusConfigurationTestControllerDefaultProperties();
    }

    @Bean
    PrometheusMetricDescriptorsCache prometheusMetricDescriptorsCache(AccountCredentialsRepository accountCredentialsRepository) {
        return new PrometheusMetricDescriptorsCache(accountCredentialsRepository);
    }

    @Bean
    MetricsService prometheusMetricsService(PrometheusResponseConverter prometheusConverter, PrometheusConfigurationProperties prometheusConfigurationProperties, RetrofitClientFactory retrofitClientFactory, OkHttpClient okHttpClient, AccountCredentialsRepository accountCredentialsRepository) {
        PrometheusMetricsService.PrometheusMetricsServiceBuilder prometheusMetricsServiceBuilder = PrometheusMetricsService.builder();
        prometheusMetricsServiceBuilder.scopeLabel(prometheusConfigurationProperties.getScopeLabel());
        for (PrometheusManagedAccount prometheusManagedAccount : prometheusConfigurationProperties.getAccounts()) {
            String name = prometheusManagedAccount.getName();
            List<AccountCredentials.Type> supportedTypes = prometheusManagedAccount.getSupportedTypes();
            log.info("Registering Prometheus account {} with supported types {}.", (Object)name, supportedTypes);
            try {
                if (!CollectionUtils.isEmpty(supportedTypes) && supportedTypes.contains(AccountCredentials.Type.METRICS_STORE)) {
                    PrometheusRemoteService prometheusRemoteService = (PrometheusRemoteService)retrofitClientFactory.createClient(PrometheusRemoteService.class, (Converter)prometheusConverter, prometheusManagedAccount.getEndpoint(), okHttpClient, prometheusManagedAccount.getUsername(), prometheusManagedAccount.getPassword(), prometheusManagedAccount.getUsernamePasswordFile(), prometheusManagedAccount.getBearerToken());
                    prometheusManagedAccount.setPrometheusRemoteService(prometheusRemoteService);
                }
                accountCredentialsRepository.save(name, (AccountCredentials)prometheusManagedAccount);
                prometheusMetricsServiceBuilder.accountName(name);
            }
            catch (IOException e) {
                log.error("Problem registering Prometheus account {}:", (Object)name, (Object)e);
            }
        }
        PrometheusMetricsService prometheusMetricsService = prometheusMetricsServiceBuilder.build();
        log.info("Populated PrometheusMetricsService with {} Prometheus accounts.", (Object)prometheusMetricsService.getAccountNames().size());
        return prometheusMetricsService;
    }

    static class PrometheusHealthEnabled
    extends AllNestedConditions {
        PrometheusHealthEnabled() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"kayenta.prometheus.accounts[0].name"}, matchIfMissing=false)
        static class accountPresent {
            accountPresent() {
            }
        }

        @ConditionalOnProperty(value={"kayenta.prometheus.health.enabled"}, havingValue="true", matchIfMissing=false)
        static class enabledHealth {
            enabledHealth() {
            }
        }
    }

    @Conditional(value={PrometheusHealthEnabled.class})
    @Configuration(proxyBeanMethods=false)
    public static class PrometheusHealthConfiguration {
        @DependsOn(value={"prometheusMetricsService"})
        @Bean
        HealthIndicator prometheusHealthIndicator(PrometheusHealthCache prometheusHealthCache) {
            return new PrometheusHealthIndicator(prometheusHealthCache);
        }

        @DependsOn(value={"prometheusMetricsService"})
        @Bean
        PrometheusHealthJob prometheusHealthJob(PrometheusConfigurationProperties prometheusConfigurationProperties, AccountCredentialsRepository accountCredentialsRepository, PrometheusHealthCache prometheusHealthCache) {
            return new PrometheusHealthJob(prometheusConfigurationProperties, accountCredentialsRepository, prometheusHealthCache);
        }

        @Bean
        PrometheusHealthCache prometheusHealthCache() {
            return new PrometheusHealthCache();
        }
    }
}

