/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.health;

import com.netflix.kayenta.prometheus.config.PrometheusConfigurationProperties;
import com.netflix.kayenta.prometheus.config.PrometheusManagedAccount;
import com.netflix.kayenta.prometheus.health.PrometheusHealthCache;
import com.netflix.kayenta.prometheus.service.PrometheusRemoteService;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Status;
import org.springframework.scheduling.annotation.Scheduled;

public class PrometheusHealthJob {
    private static final Logger log = LoggerFactory.getLogger(PrometheusHealthJob.class);
    private final PrometheusConfigurationProperties prometheusConfigurationProperties;
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final PrometheusHealthCache healthCache;

    public PrometheusHealthJob(PrometheusConfigurationProperties prometheusConfigurationProperties, AccountCredentialsRepository accountCredentialsRepository, PrometheusHealthCache healthCache) {
        this.prometheusConfigurationProperties = prometheusConfigurationProperties;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.healthCache = healthCache;
    }

    @Scheduled(initialDelayString="${kayenta.prometheus.health.initial-delay:PT2S}", fixedDelayString="${kayenta.prometheus.health.fixed-delay:PT5M}")
    public void run() {
        List<PrometheusHealthStatus> healthStatuses = this.prometheusConfigurationProperties.getAccounts().stream().map(account -> {
            String name = account.getName();
            return this.accountCredentialsRepository.getOne(name);
        }).filter(Optional::isPresent).map(Optional::get).filter(credentials -> credentials instanceof PrometheusManagedAccount).map(credentials -> (PrometheusManagedAccount)((Object)credentials)).map(credentials -> {
            try {
                PrometheusRemoteService remote = credentials.getPrometheusRemoteService();
                remote.isHealthy();
                return PrometheusHealthStatus.builder().accountName(credentials.getName()).status(Status.UP).build();
            }
            catch (Throwable ex) {
                log.warn("Prometheus health FAILED for account: {} with exception: ", (Object)credentials.getName(), (Object)ex);
                return PrometheusHealthStatus.builder().accountName(credentials.getName()).status(Status.DOWN).errorDetails(ex.getClass().getName() + ": " + ex.getMessage()).build();
            }
        }).collect(Collectors.toList());
        this.healthCache.setHealthStatuses(healthStatuses);
    }

    public static final class PrometheusHealthStatus {
        @NonNull
        private final String accountName;
        @NonNull
        private final Status status;
        @Nullable
        private final String errorDetails;

        PrometheusHealthStatus(@NonNull String accountName, @NonNull Status status, @Nullable String errorDetails) {
            if (accountName == null) {
                throw new IllegalArgumentException("accountName is marked non-null but is null");
            }
            if (status == null) {
                throw new IllegalArgumentException("status is marked non-null but is null");
            }
            this.accountName = accountName;
            this.status = status;
            this.errorDetails = errorDetails;
        }

        public static PrometheusHealthStatusBuilder builder() {
            return new PrometheusHealthStatusBuilder();
        }

        @NonNull
        public String getAccountName() {
            return this.accountName;
        }

        @NonNull
        public Status getStatus() {
            return this.status;
        }

        @Nullable
        public String getErrorDetails() {
            return this.errorDetails;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrometheusHealthStatus)) {
                return false;
            }
            PrometheusHealthStatus other = (PrometheusHealthStatus)o;
            String this$accountName = this.getAccountName();
            String other$accountName = other.getAccountName();
            if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$errorDetails = this.getErrorDetails();
            String other$errorDetails = other.getErrorDetails();
            return !(this$errorDetails == null ? other$errorDetails != null : !this$errorDetails.equals(other$errorDetails));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountName = this.getAccountName();
            result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $errorDetails = this.getErrorDetails();
            result = result * 59 + ($errorDetails == null ? 43 : $errorDetails.hashCode());
            return result;
        }

        public String toString() {
            return "PrometheusHealthJob.PrometheusHealthStatus(accountName=" + this.getAccountName() + ", status=" + this.getStatus() + ", errorDetails=" + this.getErrorDetails() + ")";
        }

        public static class PrometheusHealthStatusBuilder {
            private String accountName;
            private Status status;
            private String errorDetails;

            PrometheusHealthStatusBuilder() {
            }

            public PrometheusHealthStatusBuilder accountName(@NonNull String accountName) {
                if (accountName == null) {
                    throw new IllegalArgumentException("accountName is marked non-null but is null");
                }
                this.accountName = accountName;
                return this;
            }

            public PrometheusHealthStatusBuilder status(@NonNull Status status) {
                if (status == null) {
                    throw new IllegalArgumentException("status is marked non-null but is null");
                }
                this.status = status;
                return this;
            }

            public PrometheusHealthStatusBuilder errorDetails(@Nullable String errorDetails) {
                this.errorDetails = errorDetails;
                return this;
            }

            public PrometheusHealthStatus build() {
                return new PrometheusHealthStatus(this.accountName, this.status, this.errorDetails);
            }

            public String toString() {
                return "PrometheusHealthJob.PrometheusHealthStatus.PrometheusHealthStatusBuilder(accountName=" + this.accountName + ", status=" + this.status + ", errorDetails=" + this.errorDetails + ")";
            }
        }
    }
}

