/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.metrics;

import com.netflix.kayenta.prometheus.config.PrometheusManagedAccount;
import com.netflix.kayenta.prometheus.model.PrometheusMetricDescriptor;
import com.netflix.kayenta.prometheus.model.PrometheusMetricDescriptorsResponse;
import com.netflix.kayenta.prometheus.service.PrometheusRemoteService;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PrometheusMetricDescriptorsCache {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricDescriptorsCache.class);
    private volatile Map<String, List<PrometheusMetricDescriptor>> cache = Collections.emptyMap();
    private final AccountCredentialsRepository accountCredentialsRepository;

    public PrometheusMetricDescriptorsCache(AccountCredentialsRepository accountCredentialsRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
    }

    public List<Map> getMetadata(String metricsAccountName, String filter) {
        List<PrometheusMetricDescriptor> accountSpecificMetricDescriptorsCache = this.cache.get(metricsAccountName);
        if (CollectionUtils.isEmpty(accountSpecificMetricDescriptorsCache)) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((Object)filter)) {
            return accountSpecificMetricDescriptorsCache.stream().map(metricDescriptor -> metricDescriptor.getMap()).collect(Collectors.toList());
        }
        String lowerCaseFilter = filter.toLowerCase();
        return accountSpecificMetricDescriptorsCache.stream().filter(metricDescriptor -> metricDescriptor.getName().toLowerCase().contains(lowerCaseFilter)).map(metricDescriptor -> metricDescriptor.getMap()).collect(Collectors.toList());
    }

    @Scheduled(fixedDelayString="#{@prometheusConfigurationProperties.metadataCachingIntervalMS}")
    public void updateMetricDescriptorsCache() {
        Set accountCredentialsSet = this.accountCredentialsRepository.getAllOf(AccountCredentials.Type.METRICS_STORE);
        Map<String, List> updatedCache = accountCredentialsSet.stream().filter(credentials -> credentials instanceof PrometheusManagedAccount).map(credentials -> (PrometheusManagedAccount)((Object)credentials)).map(this::listMetricDescriptors).filter(this::isSuccessful).filter(this::hasData).collect(Collectors.toMap(AccountResponse::getMetricsAccountName, this::toPrometheusMetricDescriptors));
        this.cache = updatedCache;
    }

    private List<PrometheusMetricDescriptor> toPrometheusMetricDescriptors(AccountResponse accountResponse) {
        List<PrometheusMetricDescriptor> descriptors = accountResponse.getResponse().getData().stream().map(PrometheusMetricDescriptor::new).collect(Collectors.toList());
        log.debug("Updated cache with {} metric descriptors via account {}.", (Object)descriptors.size(), (Object)accountResponse.getMetricsAccountName());
        return descriptors;
    }

    private AccountResponse listMetricDescriptors(PrometheusManagedAccount credentials) {
        PrometheusRemoteService prometheusRemoteService = credentials.getPrometheusRemoteService();
        PrometheusMetricDescriptorsResponse remoteResponse = prometheusRemoteService.listMetricDescriptors();
        return new AccountResponse(credentials.getName(), remoteResponse);
    }

    private boolean hasData(AccountResponse accountResponse) {
        boolean empty = CollectionUtils.isEmpty(accountResponse.getResponse().getData());
        if (empty) {
            log.debug("While updating cache, found no metric descriptors via account {}.", (Object)accountResponse.getMetricsAccountName());
        }
        return !empty;
    }

    private boolean isSuccessful(AccountResponse accountResponse) {
        boolean success;
        PrometheusMetricDescriptorsResponse response = accountResponse.getResponse();
        boolean bl = success = response != null && response.getStatus().equals("success");
        if (!success) {
            log.debug("While updating cache, found no metric descriptors via account {}.", (Object)accountResponse.getMetricsAccountName());
        }
        return success;
    }

    private static final class AccountResponse {
        private final String metricsAccountName;
        private final PrometheusMetricDescriptorsResponse response;

        public AccountResponse(String metricsAccountName, PrometheusMetricDescriptorsResponse response) {
            this.metricsAccountName = metricsAccountName;
            this.response = response;
        }

        public String getMetricsAccountName() {
            return this.metricsAccountName;
        }

        public PrometheusMetricDescriptorsResponse getResponse() {
            return this.response;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountResponse)) {
                return false;
            }
            AccountResponse other = (AccountResponse)o;
            String this$metricsAccountName = this.getMetricsAccountName();
            String other$metricsAccountName = other.getMetricsAccountName();
            if (this$metricsAccountName == null ? other$metricsAccountName != null : !this$metricsAccountName.equals(other$metricsAccountName)) {
                return false;
            }
            PrometheusMetricDescriptorsResponse this$response = this.getResponse();
            PrometheusMetricDescriptorsResponse other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $metricsAccountName = this.getMetricsAccountName();
            result = result * 59 + ($metricsAccountName == null ? 43 : $metricsAccountName.hashCode());
            PrometheusMetricDescriptorsResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            return result;
        }

        public String toString() {
            return "PrometheusMetricDescriptorsCache.AccountResponse(metricsAccountName=" + this.getMetricsAccountName() + ", response=" + this.getResponse() + ")";
        }
    }
}

