/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.kayenta.prometheus.model.PrometheusMetricDescriptorsResponse;
import com.netflix.kayenta.prometheus.model.PrometheusResults;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import retrofit.converter.ConversionException;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

@Component
public class PrometheusResponseConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(PrometheusResponseConverter.class);
    private final ObjectMapper kayentaObjectMapper;

    @Autowired
    public PrometheusResponseConverter(ObjectMapper kayentaObjectMapper) {
        this.kayentaObjectMapper = kayentaObjectMapper;
    }

    public Object fromBody(TypedInput body, Type type) throws ConversionException {
        if (type == PrometheusMetricDescriptorsResponse.class) {
            return new JacksonConverter(this.kayentaObjectMapper).fromBody(body, type);
        }
        if (type == String.class) {
            try {
                return this.toString(body.in(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to parse response from Prometheus", (Throwable)e);
            }
        }
        try {
            Map responseMap = (Map)this.kayentaObjectMapper.readValue(body.in(), Map.class);
            Map data = (Map)responseMap.get("data");
            List resultList = (List)data.get("result");
            ArrayList<PrometheusResults> prometheusResultsList = new ArrayList<PrometheusResults>(resultList.size());
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return null;
            }
            for (Map elem : resultList) {
                Map tags = (Map)elem.get("metric");
                String id = (String)tags.remove("__name__");
                List values = (List)elem.get("values");
                ArrayList<Double> dataValues = new ArrayList<Double>(values.size());
                block15: for (List tuple : values) {
                    String val = (String)tuple.get(1);
                    if (val == null) continue;
                    switch (val) {
                        case "+Inf": {
                            dataValues.add(Double.POSITIVE_INFINITY);
                            continue block15;
                        }
                        case "-Inf": {
                            dataValues.add(Double.NEGATIVE_INFINITY);
                            continue block15;
                        }
                        case "NaN": {
                            dataValues.add(Double.NaN);
                            continue block15;
                        }
                    }
                    dataValues.add(Double.valueOf(val));
                }
                long startTimeMillis = PrometheusResponseConverter.doubleTimestampSecsToLongTimestampMillis(String.valueOf(((List)values.get(0)).get(0)));
                long stepSecs = values.size() > 1 ? TimeUnit.MILLISECONDS.toSeconds(PrometheusResponseConverter.doubleTimestampSecsToLongTimestampMillis(String.valueOf(((List)values.get(1)).get(0))) - startTimeMillis) : 0L;
                long endTimeMillis = startTimeMillis + (long)values.size() * stepSecs * 1000L;
                prometheusResultsList.add(new PrometheusResults(id, startTimeMillis, stepSecs, endTimeMillis, tags, dataValues));
            }
            return prometheusResultsList;
        }
        catch (IOException e) {
            throw new ConversionException("Failed to parse response from Prometheus", (Throwable)e);
        }
    }

    private Object toString(InputStream in, Charset charset) {
        try (Scanner s = new Scanner(in, charset.toString());){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    private static long doubleTimestampSecsToLongTimestampMillis(String doubleTimestampSecsAsString) {
        return (long)(Double.parseDouble(doubleTimestampSecsAsString) * 1000.0);
    }

    public TypedOutput toBody(Object object) {
        return null;
    }
}

