/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.prometheus.controllers;

import com.netflix.kayenta.canary.CanaryMetricConfig;
import com.netflix.kayenta.canary.CanaryMetricSetQueryConfig;
import com.netflix.kayenta.canary.CanaryScope;
import com.netflix.kayenta.canary.providers.metrics.PrometheusCanaryMetricSetQueryConfig;
import com.netflix.kayenta.canary.util.FetchControllerUtils;
import com.netflix.kayenta.metrics.SynchronousQueryProcessor;
import com.netflix.kayenta.prometheus.canary.PrometheusCanaryScope;
import com.netflix.kayenta.prometheus.config.PrometheusConfigurationTestControllerDefaultProperties;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fetch/prometheus"})
public class PrometheusFetchController {
    private static final Logger log = LoggerFactory.getLogger(PrometheusFetchController.class);
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final SynchronousQueryProcessor synchronousQueryProcessor;
    private final PrometheusConfigurationTestControllerDefaultProperties prometheusConfigurationTestControllerDefaultProperties;

    @Autowired
    public PrometheusFetchController(AccountCredentialsRepository accountCredentialsRepository, SynchronousQueryProcessor synchronousQueryProcessor, PrometheusConfigurationTestControllerDefaultProperties prometheusConfigurationTestControllerDefaultProperties) {
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.synchronousQueryProcessor = synchronousQueryProcessor;
        this.prometheusConfigurationTestControllerDefaultProperties = prometheusConfigurationTestControllerDefaultProperties;
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    public Map queryMetrics(@RequestParam(required=false) String metricsAccountName, @RequestParam(required=false) String storageAccountName, @Parameter(example="cpu") @RequestParam String metricSetName, @Parameter(example="node_cpu") @RequestParam String metricName, @RequestParam(required=false) List<String> groupByFields, @RequestParam(required=false) String project, @Parameter(description="Used to identify the type of the resource being queried, e.g. aws_ec2_instance, gce_instance.") @RequestParam(required=false) String resourceType, @Parameter(description="The location to use when scoping the query. Valid choices depend on what cloud platform the query relates to (could be a region, a namespace, or something else).") @RequestParam(required=false) String location, @Parameter(description="The name of the resource to use when scoping the query. The most common use-case is to provide a server group name.") @RequestParam(required=false) String scope, @Parameter(example="mode=~\"user|system\"") @RequestParam(required=false) List<String> labelBindings, @Parameter(description="An ISO format timestamp, e.g.: 2018-03-08T01:02:53Z") @RequestParam(required=false) String start, @Parameter(description="An ISO format timestamp, e.g.: 2018-03-08T01:12:22Z") @RequestParam(required=false) String end, @Parameter(example="60", description="seconds") @RequestParam Long step, @RequestParam(required=false) String customFilter, @Parameter(schema=@Schema(defaultValue="false")) @RequestParam(required=false) boolean dryRun) throws IOException {
        project = FetchControllerUtils.determineDefaultProperty((String)project, (String)"project", (Object)this.prometheusConfigurationTestControllerDefaultProperties);
        resourceType = FetchControllerUtils.determineDefaultProperty((String)resourceType, (String)"resourceType", (Object)this.prometheusConfigurationTestControllerDefaultProperties);
        location = FetchControllerUtils.determineDefaultProperty((String)location, (String)"location", (Object)this.prometheusConfigurationTestControllerDefaultProperties);
        scope = FetchControllerUtils.determineDefaultProperty((String)scope, (String)"scope", (Object)this.prometheusConfigurationTestControllerDefaultProperties);
        start = FetchControllerUtils.determineDefaultProperty((String)start, (String)"start", (Object)this.prometheusConfigurationTestControllerDefaultProperties);
        end = FetchControllerUtils.determineDefaultProperty((String)end, (String)"end", (Object)this.prometheusConfigurationTestControllerDefaultProperties);
        String resolvedMetricsAccountName = this.accountCredentialsRepository.getRequiredOneBy(metricsAccountName, AccountCredentials.Type.METRICS_STORE).getName();
        String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
        PrometheusCanaryMetricSetQueryConfig.PrometheusCanaryMetricSetQueryConfigBuilder prometheusCanaryMetricSetQueryConfigBuilder = PrometheusCanaryMetricSetQueryConfig.builder().metricName(metricName).labelBindings(labelBindings).groupByFields(groupByFields);
        if (!StringUtils.isEmpty((Object)resourceType)) {
            prometheusCanaryMetricSetQueryConfigBuilder.resourceType(resourceType);
        }
        if (!StringUtils.isEmpty((Object)customFilter)) {
            prometheusCanaryMetricSetQueryConfigBuilder.customInlineTemplate(customFilter);
        }
        CanaryMetricConfig canaryMetricConfig = CanaryMetricConfig.builder().name(metricSetName).query((CanaryMetricSetQueryConfig)prometheusCanaryMetricSetQueryConfigBuilder.build()).build();
        PrometheusCanaryScope prometheusCanaryScope = new PrometheusCanaryScope();
        prometheusCanaryScope.setScope(scope);
        prometheusCanaryScope.setLocation(location);
        prometheusCanaryScope.setStart(start != null ? Instant.parse(start) : null);
        prometheusCanaryScope.setEnd(end != null ? Instant.parse(end) : null);
        prometheusCanaryScope.setStep(step);
        if (!StringUtils.isEmpty((Object)project)) {
            prometheusCanaryScope.setProject(project);
        }
        return this.synchronousQueryProcessor.processQueryAndReturnMap(resolvedMetricsAccountName, resolvedStorageAccountName, null, canaryMetricConfig, 0, (CanaryScope)prometheusCanaryScope, dryRun);
    }
}

