/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.s3.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.kayenta.aws.security.AwsNamedAccountCredentials;
import com.netflix.kayenta.s3.storage.S3StorageService;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@ConditionalOnProperty(value={"kayenta.s3.enabled"})
@ComponentScan(value={"com.netflix.kayenta.s3"})
public class S3Configuration {
    private static final Logger log = LoggerFactory.getLogger(S3Configuration.class);
    @Autowired
    ObjectMapper kayentaObjectMapper;

    @Bean
    @DependsOn(value={"registerAwsCredentials"})
    public S3StorageService s3StorageService(AccountCredentialsRepository accountCredentialsRepository) {
        S3StorageService.S3StorageServiceBuilder s3StorageServiceBuilder = S3StorageService.builder();
        accountCredentialsRepository.getAll().stream().filter(c -> c instanceof AwsNamedAccountCredentials).filter(c -> c.getSupportedTypes().contains(AccountCredentials.Type.OBJECT_STORE)).map(c -> c.getName()).forEach(s3StorageServiceBuilder::accountName);
        S3StorageService s3StorageService = s3StorageServiceBuilder.objectMapper(this.kayentaObjectMapper).build();
        log.info("Populated S3StorageService with {} AWS accounts.", (Object)s3StorageService.getAccountNames().size());
        return s3StorageService;
    }
}

