/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.event.listener;

import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionStatusResponse;
import com.netflix.kayenta.standalonecanaryanalysis.event.StandaloneCanaryAnalysisExecutionCompletedEvent;
import com.netflix.kayenta.standalonecanaryanalysis.storage.StandaloneCanaryAnalysisObjectType;
import com.netflix.kayenta.storage.StorageService;
import com.netflix.kayenta.storage.StorageServiceRepository;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"kayenta.default-archivers.enabled"}, havingValue="true", matchIfMissing=true)
public class StandaloneCanaryAnalysisExecutionArchivalListener {
    private static final Logger log = LoggerFactory.getLogger(StandaloneCanaryAnalysisExecutionArchivalListener.class);
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final StorageServiceRepository storageServiceRepository;

    @Autowired
    public StandaloneCanaryAnalysisExecutionArchivalListener(AccountCredentialsRepository accountCredentialsRepository, StorageServiceRepository storageServiceRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.storageServiceRepository = storageServiceRepository;
    }

    @EventListener
    public void onApplicationEvent(StandaloneCanaryAnalysisExecutionCompletedEvent event) {
        CanaryAnalysisExecutionStatusResponse response = event.getCanaryAnalysisExecutionStatusResponse();
        Optional.ofNullable(response.getStorageAccountName()).ifPresent(storageAccountName -> {
            String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
            StorageService storageService = this.storageServiceRepository.getRequiredOne(resolvedStorageAccountName);
            storageService.storeObject(resolvedStorageAccountName, StandaloneCanaryAnalysisObjectType.STANDALONE_CANARY_RESULT_ARCHIVE, response.getPipelineId(), (Object)response);
        });
    }
}

