/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.orca.stage;

import com.netflix.kayenta.standalonecanaryanalysis.orca.task.MonitorCanaryTask;
import com.netflix.kayenta.standalonecanaryanalysis.orca.task.RunCanaryTask;
import com.netflix.spinnaker.orca.api.pipeline.CancellableStage;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RunCanaryStage
implements StageDefinitionBuilder,
CancellableStage {
    private static final Logger log = LoggerFactory.getLogger(RunCanaryStage.class);
    private final ExecutionRepository executionRepository;
    public static final String STAGE_TYPE = "runCanary";
    public static final String STAGE_NAME_PREFIX = "Run Canary #";

    @Autowired
    public RunCanaryStage(ExecutionRepository executionRepository) {
        this.executionRepository = executionRepository;
    }

    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
        builder.withTask(STAGE_TYPE, RunCanaryTask.class).withTask("monitorCanary", MonitorCanaryTask.class);
    }

    @Nonnull
    public String getType() {
        return STAGE_TYPE;
    }

    public CancellableStage.Result cancel(StageExecution stage) {
        Map context = stage.getContext();
        String canaryPipelineExecutionId = context.getOrDefault("canaryPipelineExecutionId", null);
        if (canaryPipelineExecutionId != null) {
            log.info("Cancelling StageExecution (stageId: {}: executionId: {}, canaryPipelineExecutionId: {}, context: {})", new Object[]{stage.getId(), stage.getExecution().getId(), canaryPipelineExecutionId, stage.getContext()});
            try {
                log.info("Cancelling pipeline execution {}...", (Object)canaryPipelineExecutionId);
                PipelineExecution pipeline = this.executionRepository.retrieve(ExecutionType.PIPELINE, canaryPipelineExecutionId);
                if (pipeline.getStatus().isComplete()) {
                    log.debug("Not changing status of pipeline execution {} to CANCELED since execution is already completed: {}", (Object)canaryPipelineExecutionId, (Object)pipeline.getStatus());
                    return new CancellableStage.Result(stage, new HashMap());
                }
                this.executionRepository.cancel(ExecutionType.PIPELINE, canaryPipelineExecutionId);
                this.executionRepository.updateStatus(ExecutionType.PIPELINE, canaryPipelineExecutionId, ExecutionStatus.CANCELED);
            }
            catch (Exception e) {
                log.error("Failed to cancel StageExecution (stageId: {}, executionId: {}), e: {}", new Object[]{stage.getId(), stage.getExecution().getId(), e.getMessage(), e});
            }
        } else {
            log.info("Not cancelling StageExecution (stageId: {}: executionId: {}, context: {}) since no canary pipeline execution id exists", new Object[]{stage.getId(), stage.getExecution().getId(), stage.getContext()});
        }
        return new CancellableStage.Result(stage, new HashMap());
    }
}

